<?php
/*
|--------------------------------------------------------------------------
| Default images which will generate while image upload
|--------------------------------------------------------------------------
|
| This option contains all available resized images
|
*/

return [
    'banner' => [
        'visibility' => 'public',
        'sizes' => [
            'fit-mobile' => [
                'width' => 680,
                'height' => 380,
                'method' => 'fit',
                'size' => 5
            ],
            'fit-ipad' => [
                'width' => 1024,
                'height' => 576,
                'method' => 'fit',
                'size' => 5
            ],
            'fit-laptop' => [
                'width' => 1440,
                'height' => 810,
                'method' => 'fit',
                'size' => 5
            ],
            'fit-setting' => [
                'width' => 1900,
                'height' => 1080,
                'method' => 'fit',
                'size' => 5,
                'is_recommended' => true
            ]
        ]
    ],
    'certificate' => [
        'visibility' => 'public',
        'sizes' => [
            'fit-setting' => [
                'width' => 1024,
                'height' => 768,
                'method' => 'fit',
                'size' => 5,
                'is_recommended' => true
            ]
        ]
    ],
    'slider' => [
        'visibility' => 'public',
        'sizes' => [
            'fit-mobile' => [
                'width' => 680,
                'height' => 380,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-ipad' => [
                'width' => 1024,
                'height' => 576,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-laptop' => [
                'width' => 1440,
                'height' => 810,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-setting' => [
                'width' => 1900,
                'height' => 1080,
                'method' => 'fit',
                'size' => 10,
                'is_recommended' => true
            ]
        ]
    ],

    'icon' => [
        'visibility' => 'public',
        'sizes' => [
            'fit-mobile' => [
                'width' => 680,
                'height' => 380,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-ipad' => [
                'width' => 1024,
                'height' => 576,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-laptop' => [
                'width' => 1440,
                'height' => 810,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-setting' => [
                'width' => 1900,
                'height' => 1080,
                'method' => 'fit',
                'size' => 10,
                'is_recommended' => true
            ]
        ]
    ],

    'profile_image' => [
        'visibility' => 'public',
        'sizes' => [
            'fit-150X150' => [
                'width' => 150,
                'height' => 150,
                'method' => 'fit',
                'size' => 10,
                'is_recommended' => true
            ],
            'fit-36x36' => [
                'width' => 36,
                'height' => 36,
                'method' => 'crop',
                'size' => 10
            ],
            'fit-32x32' => [
                'width' => 32,
                'height' => 32,
                'method' => 'crop',
                'size' => 10
            ]
        ]
    ],

    'userdocument' => [
        'visibility' => 'public',
        'sizes' => [
            'fit-setting' => [
                'size' => 10,
                'is_recommended' => true,
                'is_document' => true
            ]
        ]
    ],

    'coursecategory' => [
        'visibility' => 'public',
        'sizes' => [
            'fit-mobile' => [
                'width' => 380,
                'height' => 150,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-ipad' => [
                'width' => 380,
                'height' => 150,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-laptop' => [
                'width' => 680,
                'height' => 380,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-setting' => [
                'width' => 680,
                'height' => 380,
                'method' => 'fit',
                'size' => 10,
                'is_recommended' => true
            ]
        ]
    ],

    'media_video' => [
        'visibility' => 'public',
        'sizes' => [
            'fit-setting' => [
                'size' => 100,
                'is_recommended' => true,
                'is_video' => true
            ]
        ]
    ],

    'media_audio' => [
        'visibility' => 'public',
        'sizes' => [
            'fit-setting' => [
                'size' => 50,
                'is_recommended' => true,
                'is_audio' => true
            ]
        ]
    ],

    'media_image' => [
        'visibility' => 'public',
        'sizes' => [
            'fit-mobile' => [
                'width' => 380,
                'height' => 150,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-ipad' => [
                'width' => 380,
                'height' => 150,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-setting' => [
                'width' => 1089,
                'height' => 621,
                'method' => 'fit',
                'size' => 10,
                'is_recommended' => true
            ]
        ]
    ],

    'media_document' => [
        'visibility' => 'public',
        'sizes' => [
            'fit-setting' => [
                'size' => 10,
                'is_recommended' => true,
                'is_document' => true
            ]
        ]
    ],

    'capture_document' => [
        'visibility' => 'private',
        'sizes' => [
            'fit-mobile' => [
                'width' => 380,
                'height' => 150,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-ipad' => [
                'width' => 380,
                'height' => 150,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-setting' => [
                'width' => 380,
                'height' => 150,
                'method' => 'fit',
                'size' => 10,
                'is_recommended' => true
            ]
        ]
    ],

    'upload_file' => [
        'visibility' => 'public',
        'sizes' => [
            'fit-setting' => [
                'size' => 800,
                'is_recommended' => true,
                'is_audio' => true
            ]
        ]
    ],
    'faculty' => [
        'visibility' => 'public',
        'sizes' => [
            'fit-mobile' => [
                'width' => 380,
                'height' => 150,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-ipad' => [
                'width' => 380,
                'height' => 150,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-laptop' => [
                'width' => 680,
                'height' => 380,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-setting' => [
                'width' => 680,
                'height' => 380,
                'method' => 'fit',
                'size' => 10,
                'is_recommended' => true
            ]
        ]
    ],
    'releases' => [
        'visibility' => 'public',
        'sizes' => [
            'fit-mobile' => [
                'width' => 380,
                'height' => 150,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-ipad' => [
                'width' => 380,
                'height' => 150,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-laptop' => [
                'width' => 680,
                'height' => 380,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-setting' => [
                'width' => 680,
                'height' => 380,
                'method' => 'fit',
                'size' => 10,
                'is_recommended' => true
            ]
        ]
    ],
    'news' => [
        'visibility' => 'public',
        'sizes' => [
            'fit-mobile' => [
                'width' => 680,
                'height' => 380,
                'method' => 'fit',
                'size' => 5
            ],
            'fit-ipad' => [
                'width' => 1024,
                'height' => 576,
                'method' => 'fit',
                'size' => 5
            ],
            'fit-laptop' => [
                'width' => 1440,
                'height' => 810,
                'method' => 'fit',
                'size' => 5
            ],
            'fit-setting' => [
                'width' => 1900,
                'height' => 1080,
                'method' => 'fit',
                'size' => 5,
                'is_recommended' => true
            ]
        ]
    ],
    'member' => [
        'visibility' => 'public',
        'sizes' => [
            'fit-mobile' => [
                'width' => 380,
                'height' => 150,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-ipad' => [
                'width' => 380,
                'height' => 150,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-laptop' => [
                'width' => 680,
                'height' => 380,
                'method' => 'fit',
                'size' => 10
            ],
            'fit-setting' => [
                'width' => 680,
                'height' => 380,
                'method' => 'fit',
                'size' => 10,
                'is_recommended' => true
            ]
        ]
    ],
];
