<?php

$nullableurl = 'nullable|url';
$requiredIntegerGte1 = 'required|integer|gte:1';
$requiredIntegerMinNumeric1 = 'required|integer|min_numeric:1';
$requiredIntegerGte180 = 'required|integer|gte:120';
$requiredIntegerMinNumeric180 = 'required|integer|min_numeric:120';

return [
    /*
    |--------------------------------------------------------------------------
    | Default Siteconfigs
    |--------------------------------------------------------------------------
    |
    | This option contains all the settings
    |
    */
    [
        'title' => 'siteconfig.group_admin_setting',
        'module' => 'global',
        'inputs' => [
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'app_name',
                'label' => 'siteconfig.field_app_name',
                'help_text' => 'Application name for Admin panel.',
                'rules' => 'required',
                'client_rules' => 'required',
                'value' => env('APP_NAME', 'Laravel CMS'),
                'required' => true

            ],
            [
                'type' => 'select',
                'data' => 'int',
                'name' => 'records_per_page',
                'label' => 'siteconfig.field_record_per_page',
                'rules' => 'required',
                'client_rules' => 'required',
                'help_text' => 'Number of records display per page in administration panel.',
                'value' => 100,
                'options' => [
                    100 => 100,
                    150 => 150,
                    200 => 200,
                    250 => 250,
                    300 => 300,
                    350 => 350,
                    400 => 400,
                    450 => 450,
                    500 => 500,
                    -1 => "ALL"
                ]
            ],
            [
                'type' => 'text',
                'name' => 'footer_title_for_admin',
                'label' => 'siteconfig.field_footer_title_for_admin',
                'rules' => 'required',
                'client_rules' => 'required',
                'help_text'=> 'This will display in the footer of administration panel.',
                'value' => env('APP_NAME', 'Laravel CMS'),
                'required' => true
            ]
        ]
    ],

    [
        'title' => 'siteconfig.group_front_end_settings',
        'module' => 'global',
        'inputs' => [
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'site_title',
                'label' => 'siteconfig.field_site_title',
                'rules' => 'required',
                'client_rules' => 'required',
                'help_text' => 'Application name for front panel.',
                'value' => '',
                'required' => true
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'tagline',
                'label' => 'siteconfig.field_tagline',
                'rules' => '',
                'client_rules' => '',
                'help_text' => 'Tagline for the website',
                'value' => ''
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'pricing',
                'label' => 'siteconfig.pricing',
                'rules' => '',
                'client_rules' => '',
                'help_text' => 'Annual pricing for the website',
                'value' => ''
            ],
            [
                'type' => 'text',
                'data' => 'int',
                'name' => 'home_member_count',
                'label' => 'siteconfig.home_member_count',
                'rules' => 'required|integer',
                'client_rules' => 'required',
                'help_text' => 'Count of members to be shown on home page.',
                'value' => '',
                'required' => true
            ],
            [
                'type' => 'text',
                'data' => 'int',
                'name' => 'about_member_count',
                'label' => 'siteconfig.about_member_count',
                'rules' => 'required|integer',
                'client_rules' => 'required',
                'help_text' => 'Count of members to be shown on about page.',
                'value' => '',
                'required' => true
            ]
        ],
    ],
    [
        'title' => 'siteconfig.group_company_settings',
        'module' => 'global',
        'inputs' => [
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'company_name',
                'label' => 'siteconfig.field_company_name',
                'help_text' => 'Please enter company name',
                'rules' => 'required',
                'client_rules' => 'required',
                'value' => '',
                'required' => true

            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'company_address_line1',
                'label' => 'siteconfig.field_company_address_line1',
                'help_text' => 'Please enter company address',
                'rules' => 'required',
                'client_rules' => 'required',
                'value' => '',
                'required' => true
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'company_address_line2',
                'label' => 'siteconfig.field_company_address_line2',
                'help_text' => 'Please enter company address',
                'rules' => '',
                'client_rules' => '',
                'value' => ''
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'company_city',
                'label' => 'siteconfig.field_company_city',
                'help_text' => 'Please enter company city',
                'rules' => 'required',
                'client_rules' => 'required',
                'value' => '',
                'required' => true
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'company_state',
                'label' => 'siteconfig.field_company_state',
                'help_text' => 'Please enter company state',
                'rules' => 'required',
                'client_rules' => 'required',
                'value' => '',
                'required' => true
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'company_country',
                'label' => 'siteconfig.field_company_country',
                'help_text' => 'Please enter company country',
                'rules' => 'required',
                'client_rules' => 'required',
                'value' => '',
                'required' => true
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'company_zipcode',
                'label' => 'siteconfig.field_company_zipcode',
                'rules' => 'required|numeric|digits_between:5,6',
                'client_rules' => 'required|integer|between:5,6',
                'help_text' => 'Please enter company zipcode',
                'value' => '',
                'required' => true
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'phone',
                'label' => 'siteconfig.field_phone',
                'help_text' => 'Please enter company phone number',
                'value' => '',
                'rules' => '',
                'client_rules' => '',
                'data-mask' => '000-000-0000',
                'placeholder' => '___-___-____'
            ],
            [
                'type' => 'text',
                'data' => 'email',
                'name' => 'company_email',
                'label' => 'siteconfig.field_email',
                'help_text' => 'Please enter company email address',
                'rules' => 'email:rfc,dns',
                'client_rules' => 'email',
                'value' => '',
                'required' => false
            ]
        ],

    ],
    [
        'title' => 'siteconfig.group_email_settings',
        'module' => 'global',
        'inputs' => [
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'from_name',
                'label' => 'siteconfig.field_from_name',
                'help_text' => 'This name will be included as the from name when an email is sent from the application.',
                'rules' => 'required',
                'client_rules' => 'required',
                'value' => '',
                'required' => true
            ],
            [
                'type' => 'text',
                'data' => 'email',
                'name' => 'from_email',
                'label' => 'siteconfig.field_from_email',
                'rules' => 'required|email:rfc,dns',
                'client_rules' => 'required|email',
                'help_text' => 'This email address will be included as the from email address when an email is sent from the application.<br/> Please enter only one Email Address',
                'value' => '',
                'required' => true
            ],
            [
                'type' => 'text',
                'data' => 'email',
                'name' => 'admin_email',
                'label' => 'siteconfig.field_admin_email',
                'help' => 'siteconfig.help_admin_email',
                'help_text' => 'This email address will be included as the admin email address when an email is sent from the application.<br/> Please enter multiple email address separated by comma.<br/> Email address does not contain space before / after comma.',
                'rules' => 'required|email_array',
                'client_rules' => 'required',
                'value' => '',
                'required' => true
            ],
            [
                'type' => 'select',
                'data' => 'string',
                'name' => 'mail_providername',
                'label' => 'siteconfig.field_mail_providername',
                'rules' => 'required',
                'client_rules' => 'required',
                'value' => 'Google',
                'options' => [
                    'Google' => 'Google'
                ]
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'mail_client_id',
                'label' => 'siteconfig.field_mail_client_id',
                'rules' => '',
                'client_rules' => '',
                'value' => '',
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'mail_client_secret',
                'label' => 'siteconfig.field_mail_client_secret',
                'rules' => '',
                'client_rules' => '',
                'value' => '',
            ]
        ],
    ],
    [
        'title' => 'siteconfig.group_reporting_email_settings',
        'module' => 'global',
        'inputs' => [
            [
                'type' => 'text',
                'data' => 'email',
                'name' => 'connects_email',
                'label' => 'siteconfig.field_connects_email',
                'help' => 'siteconfig.help_connects_email',
                'help_text' => 'This email address get all Contact Us emails.<br/> Please enter multiple email address separated by comma.<br/> Email address does not contain space before / after comma.',
                'rules' => 'required|email_array',
                'client_rules' => 'required',
                'value' => '',
                'required' => true,
                'col'=>12
            ],
            [
                'type' => 'text',
                'data' => 'email',
                'name' => 'submission_reports_email',
                'label' => 'siteconfig.field_submission_reports_email',
                'help' => 'siteconfig.help_submission_reports_email',
                'help_text' => 'This email address get all Submission reports emails.<br/> Please enter multiple email address separated by comma.<br/> Email address does not contain space before / after comma.',
                'rules' => 'required|email_array',
                'client_rules' => 'required',
                'value' => '',
                'required' => true,
                'col'=>12
            ],
            [
                'type' => 'text',
                'data' => 'email',
                'name' => 'support_email',
                'label' => 'siteconfig.field_support_email',
                'help' => 'siteconfig.help_support_email',
                'help_text' => 'This email address get all Support emails.<br/> Please enter multiple email address separated by comma.<br/> Email address does not contain space before / after comma.',
                'rules' => 'required|email_array',
                'client_rules' => 'required',
                'value' => '',
                'required' => true,
                'col'=>12
            ],
            [
                'type' => 'text',
                'data' => 'email',
                'name' => 'activation_email_admin',
                'label' => 'siteconfig.field_activationmailtoadmin_email',
                'help' => 'siteconfig.help_activationmailtoadmin_email',
                'help_text' => 'This email address get all user Activation/Deactivation emails.<br/> Please enter multiple email address separated by comma.<br/> Email address does not contain space before / after comma.',
                'rules' => 'required|email_array',
                'client_rules' => 'required',
                'value' => '',
                'required' => true,
                'col'=>12
            ],
            [
                'type' => 'select',
                'name' => 'weekly_activation_emails',
                'label' => 'siteconfig.weekly_activation_emails',
                'rules' => 'required',
                'client_rules' => 'required',
                'value' => 1,
                'data-validator-label' => 'siteconfig.weekly_activation_emails',
                'required' => true,
                'help_text' => 'siteconfig.help_weekly_activation_emails',
                'options' => [
                    1 => 'Yes',
                    0 => 'No'
                ]
            ],
            [
                'type' => 'select',
                'name' => 'monthly_activation_emails',
                'label' => 'siteconfig.monthly_activation_emails',
                'rules' => 'required',
                'client_rules' => 'required',
                'value' => 1,
                'data-validator-label' => 'siteconfig.monthly_activation_emails',
                'required' => true,
                'help_text' => 'siteconfig.help_monthly_activation_emails',
                'options' => [
                    1 => 'Yes',
                    0 => 'No'
                ]
            ]
        ],
    ],
    [
        'title' => 'siteconfig.group_password_settings',
        'module' => 'global',
        'inputs' => [
            [
                'type' => 'select',
                'data' => 'string',
                'name' => 'password_strength',
                'label' => 'siteconfig.field_password_strength',
                'rules' => 'required',
                'client_rules' => 'required',
                'value' => 'Easy',
                'help_text' => '<b>Easy</b> - Only ( !  \"  #  .  @  _  `  ~  $  %  ^  *  :  ,  ;  |  -  ) special characters are allowed in the password.<br/>  <b>Medium</b> - Password should contain. 1] At least one upper case letter 2] At least one lower case letter 3] At least one digit. Only ( !  \"  #  .  @  _  `  ~  $  %  ^  *  :  ,  ;  |  -  ) special characters are allowed in the password.<br/> <b>Strong</b> - Password should contain 1] At least one upper case letter 2] At least one lower case letter 3] At least one digit 4] At least one special character ( ! \"  #  .  @  _  `  ~  $  %  ^  *  :  ,  ;  |  -  ).',
                'options' => [
                    'Easy' => 'Easy',
                    'Medium' => 'Medium',
                    'Strong' => 'Strong'
                ]
            ],
            [
                'type' => 'text',
                'data' => 'int',
                'name' => 'login_attempt',
                'label' => 'siteconfig.field_login_attempt',
                'rules' => 'required|numeric|gte:1',
                'client_rules' => 'required|numeric|min_numeric:1',
                'help_text' => 'User will block after the given number of attempt',
                'value' => 10,
                'required' => true
            ],
            [
                'type' => 'text',
                'data' => 'int',
                'name' => 'minimum_password_length',
                'label' => 'siteconfig.field_minimum_password_length',
                'rules' => 'required|numeric|gte:5|lte:12',
                'client_rules' => 'required|numeric|min_numeric:5|max_numeric:12',
                'help_text' => 'Sets minimum password length for users.',
                'value' => 8,
                'required' => true
            ],
            [
                'type' => 'text',
                'data' => 'int',
                'name' => 'user_block_time',
                'label' => 'siteconfig.field_user_block_time',
                'help' => 'siteconfig.help_user_block_time',
                'rules' => 'required|numeric|gte:1',
                'client_rules' => 'required|numeric|min_numeric:1',
                'help_text' => 'Please enter block time in minutes only.<br />User will block for this time duration',
                'value' => 1,
                'required' => true
            ]
        ],
    ],
    [
        'title' => 'siteconfig.group_archive_setting',
        'module' => 'global',
        'inputs' => [
            [
                'type' => 'text',
                'name' => 'archive_days',
                'label' => 'siteconfig.field_archive_days',
                'rules' => $requiredIntegerGte180,
                'client_rules' => $requiredIntegerMinNumeric180,
                'value' => '180',
                'data-validator-label' => 'archive day',
                'required' => true,
                'help_text' => 'Please enter when user login details will archive in days',
            ],
            [
                'type' => 'select',
                'name' => 'enable_access_log',
                'label' => 'siteconfig.field_enable_access_log',
                'rules' => 'required',
                'client_rules' => 'required',
                'value' => 1,
                'data-validator-label' => 'Enable Access Log',
                'required' => true,
                'help_text' => 'Please select whether to enable/disable access log',
                'options' => [
                    1 => 'Yes',
                    0 => 'No'
                ]
            ]

        ]
    ],
    [
        'title' => 'siteconfig.group_app_settings',
        'module' => 'global',
        'inputs' => [
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'ios_app_version',
                'label' => 'siteconfig.field_ios_app_version',
                'help_text' => 'Please enter IOS app version',
                'rules' => '',
                'client_rules' => '',
                'value' => '1.0'
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'android_app_version',
                'label' => 'siteconfig.field_android_app_version',
                'help_text' => 'Please enter Android App Version',
                'rules' => '',
                'client_rules' => '',
                'value' => '1.0'
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'web_version',
                'label' => 'siteconfig.field_web_version',
                'help_text' => 'Please enter Web Version',
                'rules' => '',
                'client_rules' => '',
                'value' => '1.0'
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'app_web_url',
                'label' => 'siteconfig.field_app_web_url',
                'help_text' => 'Please enter App web URL',
                'rules' => $nullableurl,
                'client_rules' => $nullableurl,
                'value' => ''
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'android_app_id',
                'label' => 'siteconfig.field_android_app_id',
                'help_text' => 'Please enter Android App Id',
                'rules' => '',
                'client_rules' => '',
                'value' => ''
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'ios_app_id',
                'label' => 'siteconfig.field_ios_app_id',
                'help_text' => 'Please enter iOS App Id',
                'rules' => '',
                'client_rules' => '',
                'value' => ''
            ],
            [
                'type' => 'text',
                'data' => 'int',
                'name' => 'api_pagination',
                'label' => 'siteconfig.api_pagination',
                'help_text' => 'App pagination value',
                'rules' => 'required',
                'client_rules' => 'required',
                'value' => ''
            ],

        ],
    ],
    [
        'title' => 'siteconfig.group_seo_settings',
        'module' => 'global',
        'inputs' => [
            [
                'type' => 'text',
                'name' => 'robots_meta_tag',
                'label' => 'siteconfig.field_robots_meta_tag',
                'help_text' => 'Please enter google robots meta tag',
                'rules' => '',
                'client_rules' => '',
                'value' => '<meta name="robots" content="noindex, nofollow" />'
            ],
            [
                'type' => 'textarea',
                'data' => 'string',
                'name' => 'google_analytics_code',
                'label' => 'siteconfig.field_google_analytics_code',
                'help_text' => 'Please enter google analytics code',
                'rules' => '',
                'client_rules' => '',
                'value' => ''
            ],
            [
                'type' => 'textarea',
                'data' => 'string',
                'name' => 'google_tag_manager_code',
                'label' => 'siteconfig.field_google_tag_manager_code',
                'help_text' => 'Please enter google tag manager code',
                'rules' => '',
                'client_rules' => '',
                'value' => ''
            ]
        ],
    ],


    /* Our Team Settings */
    [
        'title' => 'siteconfig.group_our_team_settings',
        'module' => 'team',
        'inputs' => [
            [
                'type' => 'textarea',
                'name' => 'our_team_title',
                'label' => 'siteconfig.field_our_team_title',
                'rules' => 'required',
                'client_rules' => 'required',
                'data-validator-label' => 'title',
                'value' => 'Why The Laravel CMS Team?',
                'required' => true
            ],
            [
                'type' => 'textarea',
                'name' => 'our_team_sub_title',
                'label' => 'siteconfig.field_our_team_sub_title',
                'rules' => 'required',
                'client_rules' => 'required',
                'data-validator-label' => 'sub_title',
                'value' => 'Who are we',
                'required' => true
            ],
        ],
    ],

    /* Contact Settings */
    [
        'title' => 'siteconfig.group_contact_settings',
        'module' => 'contact',
        'inputs' => [
            [
                'type' => 'textarea',
                'name' => 'contact_title',
                'label' => 'siteconfig.field_contact_title',
                'rules' => 'required',
                'client_rules' => 'required',
                'data-validator-label' => 'title',
                'value' => 'Leave a request and our manager will contact you',
                'required' => true
            ],
            [
                'type' => 'textarea',
                'name' => 'contact_thank_you_message',
                'label' => 'siteconfig.field_contact_thank_you_message',
                'rules' => 'required',
                'client_rules' => 'required',
                'data-validator-label' => 'thank_you_message',
                'value' => 'Thank you for contacting us. We will respond to you as soon as possible.',
                'required' => true
            ],
            [
                'type' => 'text',
                'data' => 'email',
                'name' => 'contact_email',
                'label' => 'siteconfig.field_contact_email',
                'help' => 'siteconfig.help_contact_email',
                'rules' => 'required|email_array',
                'client_rules' => 'required',
                'data-validator-label' => 'email',
                'value' => '',
                'required' => true
            ],
            [
                'type' => 'select',
                'name' => 'user_contact_acknowledge',
                'label' => 'siteconfig.user_contact_acknowledge',
                'value' => 'No',
                'rules'=>'',
                'client_rules' => '',
                'options' => [
                    'No' => 'No',
                    'Yes' => 'Yes',
                ]
            ],
        ],
    ],

    /* Slider Settings */
    [
        'title' => 'siteconfig.group_slider_settings',
        'module' => 'slider',
        'inputs' => [
            [
                'type' => 'select',
                'name' => 'field_slider_title_display',
                'label' => 'siteconfig.field_slider_title_display',
                'value' => 'No',
                'rules'=>'',
                'client_rules' => '',
                'options' => [
                    'No' => 'No',
                    'Yes' => 'Yes',
                ]
            ],
        ],
    ],

    /* Testimonial Settings */
    [
        'title' => 'siteconfig.group_testimonial_settings',
        'module' => 'testimonial',
        'inputs' => [
            [
                'type' => 'select',
                'name' => 'field_testimonial_title_display',
                'label' => 'siteconfig.field_testimonial_title_display',
                'value' => 'No',
                'rules'=>'',
                'client_rules' => '',
                'options' => [
                    'No' => 'No',
                    'Yes' => 'Yes',
                ]
            ],
        ],
    ],

    /* blog Settings */
    [
        'title' => 'siteconfig.group_blog_settings',
        'module' => 'blog',
        'inputs' => [
            [
                'type' => 'text',
                'name' => 'field_blog_per_page_display',
                'label' => 'siteconfig.field_blog_per_page_display',
                'rules' => $requiredIntegerGte1,
                'client_rules' => $requiredIntegerMinNumeric1,
                'value' => '10',
                'data-validator-label' => 'blog per page display',
                'required' => true,
            ],
            [
                'type' => 'select',
                'name' => 'comment_moderation',
                'label' => 'siteconfig.comment_moderation',
                'value' => 'No',
                'rules'=>'',
                'client_rules' => '',
                'options' => [
                    'Yes' => 'Yes with mail notification',
                    'Yesw' => 'Yes without mail notification',
                    'No' => 'No',
                ]
            ],
        ],
    ],
    /* Login Lifetime  Settings */
    [
        'title' => 'siteconfig.group_login_timeout_settings',
        'module' => 'global',
        'inputs' => [
            [
                'type' => 'text',
                'data' => 'int',
                'help_text' => 'siteconfig.help_admin_login_lifetime',
                'name' => 'admin_login_lifetime',
                'label' => 'siteconfig.admin_login_lifetime',
                'rules' => $requiredIntegerGte1,
                'client_rules' => $requiredIntegerMinNumeric1,
                'value' => 30,
                'data-validator-label' => 'admin login lifetime',
                'required' => true,
            ],
            [
                'type' => 'text',
                'data' => 'int',
                'help_text' => 'siteconfig.help_api_access_token_lifetime',
                'name' => 'api_access_token_lifetime',
                'label' => 'siteconfig.api_access_token_lifetime',
                'rules' => $requiredIntegerGte1,
                'client_rules' => $requiredIntegerMinNumeric1,
                'value' => 30,
                'data-validator-label' => 'front login lifetime',
                'required' => true,
            ],
        ],
    ],
    [
        'title' => 'siteconfig.group_social_networking',
        'module' => 'global',
        'inputs' => [
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'facebook_link',
                'label' => 'siteconfig.field_facebook_link',
                'rules' => 'required',
                'client_rules' => 'required',
                'value' => '',
                'required' => true
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'twitter_link',
                'label' => 'siteconfig.field_twitter_link',
                'rules' => 'required',
                'client_rules' => 'required',
                'value' => '',
                'required' => true
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'linkedin_link',
                'label' => 'siteconfig.field_linkedin_link',
                'rules' => 'required',
                'client_rules' => 'required',
                'value' => '',
                'required' => true
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'instagram_link',
                'label' => 'siteconfig.field_instagram_link',
                'rules' => 'required',
                'client_rules' => 'required',
                'value' => '',
                'required' => true
            ],
        ]
    ],
    [
        'title' => 'siteconfig.brand_product_settings',
        'module' => 'global',
        'inputs' => [
            [
                'type' => 'tinymce',
                'data' => 'string',
                'help_text' => 'siteconfig.help_brand_product_content',
                'name' => 'brand_product_content',
                'label' => 'siteconfig.brand_product_content',
                'rules' => '',
                'client_rules' => '',
                'value' => '',
            ],
            [
                'type' => 'select',
                'name' => 'branding_status',
                'label' => 'siteconfig.branding_status',
                'rules' => 'required',
                'client_rules' => 'required',
                'value' => 1,
                'data-validator-label' => 'siteconfig.branding_status',
                'required' => true,
                'help_text' => 'siteconfig.help_branding_status',
                'options' => [
                    1 => 'Yes',
                    0 => 'No'
                ]
            ],
            [
                'type' => 'select',
                'name' => 'show_subscribe_popup',
                'label' => 'siteconfig.show_subscribe_popup',
                'rules' => 'required',
                'client_rules' => 'required',
                'value' => 1,
                'data-validator-label' => 'siteconfig.show_subscribe_popup',
                'required' => true,
                'help_text' => 'siteconfig.help_show_subscribe_popup',
                'options' => [
                    1 => 'Yes',
                    0 => 'No'
                ]
            ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'stripe_discount_code',
                'label' => 'siteconfig.stripe_discount_code',
                'rules' => 'required_if:show_subscribe_popup,1',
                'client_rules' => 'required_if:show_subscribe_popup,1',
                'value' => '',
                'required' => true
            ],
            // [
            //     'type' => 'text',
            //     'data' => 'string',
            //     'name' => 'stripe_discount_key',
            //     'label' => 'siteconfig.stripe_discount_key',
            //     'rules' => '',
            //     'client_rules' => '',
            //     'value' => '',
            //     'required' => false,
            //     'readonly'=>true,
            // ],
            [
                'type' => 'text',
                'data' => 'string',
                'name' => 'subscribe_popup_discount_value',
                'label' => 'siteconfig.subscribe_popup_discount_value',
                'rules' => 'required_if:show_subscribe_popup,1',
                'client_rules' => 'required_if:show_subscribe_popup,1',
                'help_text' => 'siteconfig.help_subscribe_popup_discount_value',
                'value' => '',
                'required' => true,
                'readonly'=>true,
            ],
            [
                'type' => 'date',
                'data' => 'date',
                'name' => 'subscribe_popup_date_value',
                'label' => 'siteconfig.subscribe_popup_date_value',
                'rules' => '',
                'client_rules' => '',
                'help_text' => 'siteconfig.help_subscribe_popup_date_value',
                'value' => '',
                'required' => false,
                // 'readonly'=>true,
            ],
        ],
    ],
];
