<?php
return [
    'dashboard' => [
        'title' => 'Dashboard',
        'permissions' => [
            [
                'key'   => 'dashboard',
                'route' => ['dashboard'],
                'title' => 'Dashboard'
            ],
        ],
        'blacklist' => [],
        'whitelist' => [],
    ],
    'admin' => [
        'title' => 'Admins/User',
        'permissions' => [
            [
                'key'   => 'user-list',
                'route' => ['user.index','student.list'],
                'title' => 'View'
            ],
            [
                'key'   => 'manage-user',
                'route' => ['user.create', 'user.store', 'user.edit', 'user.update', 'user.bulkaction','user.changestatus', 'student.create','student.edit','user.reset-password','student.progressedit','courseprogress.update'],
                'title' => 'Add/Edit/Delete'
            ]
        ],
        'blacklist' => [],
        'whitelist' => [],
    ],

    'student' => [
        'title' => 'App Users',
        'permissions' => [
            [
                'key'   => 'student-list',
                'route' => ['student.list'],
                'title' => 'View'
            ],
            [
                'key'   => 'manage-student',
                'route' => ['student.enrollcourse','student.enrollcourseupdate','coursepdfcertificateadmin','coursecertificateadmin','coursedescriptionadmin','student.progress','user.store','user.update','user.bulkaction','user.changestatus','user.reset-password','student.create','student.edit'],
                'title' => 'Add/Edit/Delete'
            ]
        ],
        'blacklist' => [],
        'whitelist' => [],
    ],

    'pages' => [
        'title' => 'Pages',
        'permissions' => [
            [
                'key'   => 'page-index',
                'route' => ['page.index'],
                'title' => 'View'
            ],
            [
                'key'   => 'manage-page',
                'route' => ['page.create', 'page.store', 'page.edit', 'page.update', 'page.bulkaction', 'page.changestatus'],
                'title' => 'Add/Edit/Delete'
            ]
        ],
        'blacklist' => [],
        'whitelist' => [],
    ],
    'firms' => [
        'title' => 'Firms',
        'permissions' => [
            [
                'key'   => 'firm-index',
                'route' => ['firm.index'],
                'title' => 'View'
            ],
            [
                'key'   => 'manage-firm',
                'route' => ['firm.create', 'firm.store', 'firm.edit', 'firm.update', 'firm.bulkaction', 'firm.changestatus'],
                'title' => 'Add/Edit/Delete'
            ]
        ],
        'blacklist' => [],
        'whitelist' => [],
    ],
    'bars' => [
        'title' => 'Bars',
        'permissions' => [
            [
                'key'   => 'bar-index',
                'route' => ['bar.index'],
                'title' => 'View'
            ],
            [
                'key'   => 'manage-bar',
                'route' => ['bar.create', 'bar.store', 'bar.edit', 'bar.update', 'bar.bulkaction', 'bar.changestatus'],
                'title' => 'Add/Edit/Delete'
            ]
        ],
        'blacklist' => [],
        'whitelist' => [],
    ],

    'content' => [
        'title' => 'Contents',
        'permissions' => [
            [
                'key'   => 'content-index',
                'route' => ['content.index'],
                'title' => 'View'
            ],
            [
                'key'   => 'manage-content',
                'route' => ['content.create', 'content.store', 'content.edit', 'content.update', 'content.bulkaction', 'content.changestatus'],
                'title' => 'Add/Edit/Delete'
            ]
        ],
        'blacklist' => [],
        'whitelist' => [],
    ],
   'role' => [
        'title' => 'Roles',
        'permissions' => [
            [
                'key'   => 'role-index',
                'route' => ['role.index'],
                'title' => 'View'
            ],
            [
                'key'   => 'manage-role',
                'route' => ['role.create', 'role.store', 'role.edit', 'role.update', 'role.bulkaction', 'role.changestatus'],
                'title' => 'Add/Edit/Delete'
            ]
        ],
        'blacklist' => [],
        'whitelist' => [],
    ],
    'iptracker' => [
        'title' => 'IP Tracker',
        'permissions' => [
            [
                'key'   => 'iptracker',
                'route' => ['iptracker.index','iptracker.getdata'],
                'title' => 'View'
            ]
        ],
        'blacklist' => [],
        'whitelist' => [],
    ],
    'profile' => [
        'title' => 'My Profile',
        'permissions' => [
            [
                'key'   => 'my-profile',
                'route' => ['profile','profile.update'],
                'title' => 'Profile'
            ],
            [
                'key'   => 'change-password',
                'route' => ['user.change-password','user.update-password'],
                'title' => 'Change Password'
            ],
        ],
        'blacklist' => [],
        'whitelist' => [],
    ],
    'site-config' => [
        'title' => 'Site Config',
        'permissions' => [
            [
                'key'   => 'site-config-global',
                'title' => 'Site Config - Global',
                'route' => ['site-config', 'site-config.save'],
            ],
        ],
    ],
    'contact-us' => [
        'title' => 'Contact Us',
        'permissions' => [
            [
                'key'   => 'contactus-index',
                'route' => ['contactus.index'],
                'title' => 'View'
            ],
            [
                'key'   => 'manage-contactus',
                'route' => ['contactus.bulkaction'],
                'title' => 'Delete'
            ]
        ],
        'blacklist' => [],
        'whitelist' => [],
    ],
    'support' => [
        'title' => 'Support Inquiries',
        'permissions' => [
            [
                'key'   => 'support-index',
                'route' => ['support.index'],
                'title' => 'View'
            ],
            [
                'key'   => 'manage-support',
                'route' => ['support.bulkaction'],
                'title' => 'Delete'
            ]
        ],
        'blacklist' => [],
        'whitelist' => [],
    ],
    'submissions' => [
        'title' => 'Submissions',
        'permissions' => [
            [
                'key'   => 'submissions-index',
                'route' => ['submissions.index'],
                'title' => 'View'
            ],
            [
                'key'   => 'manage-submissions',
                'route' => ['submissions.bulkaction'],
                'title' => 'Delete'
            ]
        ],
        'blacklist' => [],
        'whitelist' => [],
    ],
    'subscriptions' => [
        'title' => 'Subscriptions',
        'permissions' => [
            [
                'key'   => 'subscriptions-index',
                'route' => ['subscriptions.index'],
                'title' => 'View'
            ],
            [
                'key'   => 'manage-subscriptions',
                'route' => ['subscriptions.bulkaction'],
                'title' => 'Delete'
            ]
        ],
        'blacklist' => [],
        'whitelist' => [],
    ],
];
