<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use App\Category;
use Faker\Generator as Faker;

$factory->define(Category::class, function (Faker $faker) {
    return [
        'title' => $faker->sentence,
        'description' => $faker->paragraph,
        'image' => '13b73edae8443990be1aa8f1a483bc27.jpg',
        'image_alt' => $faker->word,
        'meta_title' => $faker->sentence,
        'meta_description' => $faker->paragraph,
        'status' => $faker->randomElement([0, 1]),
    ];
});

$factory->defineAs(Category::class, 'db_record', function (Faker $faker) {
    return [
        'title' => $faker->sentence,
        'slug' => $faker->slug,
        'description' => $faker->paragraph,
        'image' => '13b73edae8443990be1aa8f1a483bc27.jpg',
        'image_alt' => $faker->word,
        'meta_title' => $faker->sentence,
        'meta_description' => $faker->paragraph,
        'display_order' => $faker->unique()->randomDigitNot(0),
        'status' => $faker->randomElement([0, 1]),
    ];
});

$factory->state(Category::class, 'active', [
    'status' => 1,
]);

$factory->state(Category::class, 'inactive', [
    'status' => 0,
]);
