<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use App\SiteConfig;
use Faker\Generator as Faker;

/*
|--------------------------------------------------------------------------
| Model Factories
|--------------------------------------------------------------------------
|
| This directory should contain each of the model factory definitions for
| your application. Factories provide a convenient way to generate new
| model instances for testing / seeding your application's database.
|
 */

$factory->defineAs(SiteConfig::class, 'global', function (Faker $faker) {
    return [
        'app_name' => env('APP_NAME', 'Laravel CMS'),
        'records_per_page' => $faker->randomElement([100, 150, 200, 250, 300, 350, 400, 450, 500, -1]),
        'footer_title_for_admin' => env('APP_NAME', 'Laravel CMS'),

        'site_title' => $faker->sentence,
        'copyright_text' => $faker->sentence,

        'company_name' => $faker->company,
        'company_address_line1' => $faker->streetAddress,
        'company_city' => $faker->city,
        'company_state' => $faker->state,
        'company_country' => $faker->country,
        'company_zipcode' => $faker->randomNumber(5),

        'from_name' => $faker->name,
        'from_email' => $faker->companyEmail,
        'admin_email' => $faker->email . ',' . $faker->email . ',' . $faker->email,

        'password_strength' => $faker->randomElement(['Easy', 'Medium', 'Strong']),
        'login_attempt' => 10,
        'minimum_password_length' => 8,
        'user_block_time' => 1,

        'robots_meta_tag' => '<meta name="robots" content="noindex, nofollow" />',

        'tagline' => $faker->sentence,
        'meta_description_for_front' => $faker->text,

        'company_address_line2' => $faker->secondaryAddress,
        'phone' => '201-886-0269',
        'company_email' => $faker->companyEmail,
        'googlemap_embedded' => '<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3690.9474617286137!2d73.16650917600124!3d22.317826642258584!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x395fc99193557c75%3A0x43f0b7a7c4b7a29d!2sKernelEquity%20Technologies%20Pvt%20Ltd!5e0!3m2!1sen!2sin!4v1719207075939!5m2!1sen!2sin" width="600" height="310" frameborder="0" style="border:0;" allowfullscreen=""></iframe>',

        'facebook_link' => $faker->url,
        'twitter_link' => $faker->url,
        'linkedin_link' => $faker->url,
        'instagram_link' => $faker->url,

        'GOOGLE_RECAPTCHA_KEY' => '6LdmjcAUAAAAAOC91odgsGtSXIWTZN1awIdSi3c7',
        'GOOGLE_RECAPTCHA_SECRET' => '6LdmjcAUAAAAAELEx5ApNkj-zJW3j-d4BafVbN8x',

        'google_analytics_code' => '',
        'google_tag_manager_code' => ''
    ];
});

$factory->defineAs(SiteConfig::class, 'global-required-fields-and-errors', function () {
    return [
        'app_name' => 'The app name field is required.',
        'records_per_page' => 'The records per page field is required.',
        'footer_title_for_admin' => 'The footer title for admin field is required.',

        'site_title' => 'The site title field is required.',
        'copyright_text' => 'The copyright text field is required.',

        'company_name' => 'The company name field is required.',
        'company_address_line1' => 'The company address line1 field is required.',
        'company_city' => 'The company city field is required.',
        'company_state' => 'The company state field is required.',
        'company_country' => 'The company country field is required.',
        'company_zipcode' => 'The company zipcode field is required.',

        'from_email' => 'The from email field is required.',
        'admin_email' => 'The admin email field is required.',

        'password_strength' => 'The password strength field is required.',
        'login_attempt' => 'The login attempt field is required.',
        'minimum_password_length' => 'The minimum password length field is required.',
        'user_block_time' => 'The user block time field is required.',
    ];
});

$factory->defineAs(SiteConfig::class, 'team', function (Faker $faker) {
    return [
        'our_team_title' => $faker->sentence,
        'our_team_sub_title' => $faker->sentence,
    ];
});

$factory->defineAs(SiteConfig::class, 'team-required-fields-and-errors', function () {
    return [
        'our_team_title' => 'The title field is required.',
        'our_team_sub_title' => 'The sub title field is required.',
    ];
});

$factory->defineAs(SiteConfig::class, 'testimonial', function (Faker $faker) {
    return [
        'field_testimonial_title_display' => $faker->randomElement(['Yes', 'No']),
    ];
});

$factory->defineAs(SiteConfig::class, 'blog', function (Faker $faker) {
    return [
        'field_blog_per_page_display' => $faker->randomDigitNotNull,
        'comment_moderation' => $faker->randomElement(['Yes', 'Yesw', 'No']),
    ];
});

$factory->defineAs(SiteConfig::class, 'blog-required-fields-and-errors', function () {
    return [
        'field_blog_per_page_display' => 'The blog per page display field is required.',
    ];
});

$factory->defineAs(SiteConfig::class, 'slider', function (Faker $faker) {
    return [
        'field_slider_title_display' => $faker->randomElement(['Yes', 'No']),
    ];
});

$factory->defineAs(SiteConfig::class, 'contact', function (Faker $faker) {
    return [
        'contact_title' => $faker->word,
        'contact_thank_you_message' => $faker->sentence,
        'contact_email' => $faker->companyEmail,
        'user_contact_acknowledge' => $faker->randomElement(['Yes', 'No']),
    ];
});

$factory->defineAs(SiteConfig::class, 'contact-required-fields-and-errors', function () {
    return [
        'contact_title' => 'The title field is required.',
        'contact_thank_you_message' => 'The thank you message field is required.',
        'contact_email' => 'The contact email field is required.',
    ];
});
