<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use App\User;
use Illuminate\Support\Str;
use Faker\Generator as Faker;

/*
|--------------------------------------------------------------------------
| Model Factories
|--------------------------------------------------------------------------
|
| This directory should contain each of the model factory definitions for
| your application. Factories provide a convenient way to generate new
| model instances for testing / seeding your application's database.
|
*/

$factory->define(User::class, function (Faker $faker) {
    return [
        'first_name' => $faker->firstname,
        'last_name' => $faker->lastname,
        'user_type_id' => 2,
        'email' => $faker->unique()->safeEmail,
        'email_verified_at' => now(),
        'status' => 1,
        'password' => '$2y$10$XAwD0.sWwkLz0bWHEk54Q.5LzkcOtS4Uhklv786B5CQ9qHSJm2GxO', // Mvc@082019
        'remember_token' => Str::random(10),
        'email_verified_at' => now(),

        // 'user_type_id' => 2,
        // 'email' => $faker->unique()->safeEmail,
        // 'password' => '$2y$10$XAwD0.sWwkLz0bWHEk54Q.5LzkcOtS4Uhklv786B5CQ9qHSJm2GxO', // Mvc@082019
        // 'first_name' => $faker->firstname,
        // 'last_name' => $faker->lastname,
        // 'status' => 1,
    ];
});

$factory->state(User::class, 'not_verified', [
    'password' => null,
    'status' => 0,
    'remember_token' => null,
    'email_verified_at' => null,
]);

$factory->state(User::class, 'inactivated', [
    'status' => 0,
]);

$factory->state(User::class, 'deleted', [
    'deleted_at' => now(),
]);
