<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMenusTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('menus')) {
                Schema::create('menus', function (Blueprint $table) {
                    $table->engine = 'InnoDB';
                    $table->increments('id',10);
                    $table->char('title', 100);
                    $table->string('route_name');
                    $table->char('params', 255)->nullable();
                    $table->string('icon')->nullable();
                    $table->string('imageurl')->nullable();
                    $table->enum('type', ['Admin', 'Front']);
                    $table->integer('parent_id')->unsigned()->default(0);
                    $table->integer('display_order')->unsigned();
                    $table->tinyInteger('status')->default(1);
                    $table->integer('created_by')->unsigned()->default(0);
                    $table->integer('updated_by')->unsigned()->default(0);
                    $table->nullableTimestamps();
                    $table->softDeletes();
            });

            Artisan::call('db:seed', array('--class' => 'MenuTableSeeder'));
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('menus');
    }
}
