<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('pages')) {
            Schema::create('pages', function (Blueprint $table) {
                $table->increments('id',10);
                $table->string('title', 100)->nullable();
                $table->string('slug', 255);
                $table->mediumText('description')->nullable();
                $table->string('banner')->nullable();
                $table->mediumText('banner_content')->nullable();
                $table->string('banner_alt', 100)->nullable();
                $table->string('meta_title')->nullable();
                $table->mediumText('meta_desc')->nullable();
                $table->text('modules')->nullable();
                $table->tinyInteger('status')->default(1)->comment('0- Inactive,1-Active');
                $table->integer('created_by')->unsigned()->default(0);
                $table->integer('updated_by')->unsigned()->default(0);
                $table->timestamps();
                $table->softDeletes();
                $table->engine = 'InnoDB';   
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pages');
    }
}
