<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteConfigsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('site_configs')) {
            Schema::create('site_configs', function (Blueprint $table) {
                $table->integerIncrements('id');
                $table->string('name')->nullable();
                $table->mediumText('val')->nullable();
                $table->tinyInteger('status')->default(1)->comment('0-Inactive,1-Active');
                $table->string('type', 10)->nullable();
                $table->integer('created_by')->unsigned()->default(0);
                $table->integer('updated_by')->unsigned()->default(0);
                $table->timestamps();
                $table->softDeletes();
                $table->engine = 'InnoDB';
            });

        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_configs');
    }
}
