<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('users')) {
            Schema::create('users', function (Blueprint $table) {
                $table->integerIncrements('id');
                $table->tinyInteger('user_type_id')->unsigned()->comment('1 = Admin 2 = Firm Admin 3 = App user')->default(2);
                $table->foreign('user_type_id')->references('id')->on('user_types');
                $table->string('email');
                $table->string('password')->nullable();
                $table->string('first_name')->nullable();
                $table->string('last_name')->nullable();
                $table->string('profile_image')->nullable();
                $table->tinyInteger('status')->default(0)->comment('0-Inactive,1-Active');
                $table->string('remember_token', 100)->nullable();
                $table->dateTime('email_verified_at')->nullable();
                $table->dateTime('last_login_at')->nullable();
                $table->string('last_login_ip', 50)->nullable();
                $table->integer('created_by')->unsigned()->nullable();
                $table->integer('updated_by')->unsigned()->nullable();
                $table->timestamps();
                $table->softDeletes();
                $table->engine = 'InnoDB';
            });
            Artisan::call('db:seed', array('--class' => 'DefaultSetupSeeder'));
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
