<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;

class CreateAppUserAuthorizationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('app_user_authorizations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('user_id')->nullable();
            $table->string('oauth_access_token_id',100)->nullable();
            $table->text('access_token')->nullable();
            $table->text('refresh_token')->nullable();
            $table->string('device_id')->nullable();
            $table->string('device_token',255)->nullable();
            $table->enum('device_type', ['android', 'ios'])->default('android');
            $table->string('device_brand')->nullable();
            $table->string('device_name')->nullable();
            $table->string('device_version')->nullable();
            $table->string('app_version')->nullable();
            $table->string('api_version')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
        Artisan::call('db:seed', array('--class' => 'addDeviceVersionOfSiteConfig'));
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
         Schema::dropIfExists('app_user_authorizations');
    }
}
