<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateActivityLogArchivesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('activity_log_archives')) {
            Schema::create('activity_log_archives', function (Blueprint $table) {
                    $table->engine = 'InnoDB';
                    $table->integerIncrements('id',10);
                    $table->string('session_id');
                    $table->integer('user_id')->unsigned()->nullable();
                    $table->string('model', 100)->nullable();
                    $table->string('activity', 100)->nullable();
                    $table->unsignedInteger('pk_id')->nullable();
                    $table->mediumText('data')->nullable();
                    $table->string('ip_address', 45)->nullable();
                    $table->datetime('archive_date');
                    $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('activity_log_archives');
    }
}
