<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterUserTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        //
        Schema::table('users', function ($table) {
            $table->text('address')->nullable()->after('profile_image');
            $table->string('phone')->nullable()->after('address');
            $table->string('city')->nullable()->after('phone');
            $table->unsignedInteger('state_id')->nullable()->after('city');
            $table->string('zipcode')->nullable()->after('state_id');
            $table->string('company_name')->nullable()->after('zipcode');
            $table->string('job_title')->nullable()->after('company_name');
            $table->date('birthdate')->nullable()->after('job_title');
            $table->string('last_four_ssn')->nullable()->after('birthdate');
            $table->string('unit')->nullable()->after('last_four_ssn');
            $table->text('user_bio')->nullable()->after('unit');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table)
        {
            $table->dropColumn('address');
            $table->dropColumn('phone');
            $table->dropColumn('city');
            $table->dropColumn('state_id');
            $table->dropColumn('zipcode');
            $table->dropColumn('company_name');
            $table->dropColumn('job_title');
            $table->dropColumn('birthdate');
            $table->dropColumn('last_four_ssn');
            $table->dropColumn('unit');
            $table->dropColumn('user_bio');
        });
    }
}
