<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUserRolesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('user_roles')) {
            Schema::create('user_roles', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->bigInteger('user_type_id');
                $table->string('name')->nullable();
                $table->string('shortname')->nullable();
                $table->mediumText('permission')->nullable();
                $table->integer('sortorder')->unsigned()->default(0);
                $table->tinyInteger('status')->default(1)->comment('0-Inactive,1-Active');
                $table->timestamps();
                $table->softDeletes();
                $table->engine = 'InnoDB';
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_roles');
    }
}
