<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        //
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('ssn');
            $table->dropColumn('address');
            $table->dropColumn('preferedmethod');
            $table->dropColumn('city');
            $table->dropColumn('state_id');
            $table->dropColumn('zipcode');
            $table->dropColumn('last_four_ssn');
            $table->dropColumn('unit');
            $table->dropColumn('user_bio');

            $table->string('firmcode')->nullable()->after('birthdate');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
        Schema::table('users', function (Blueprint $table) {
            $table->integer('ssn')->nullable()->after('email');
            $table->text('address')->nullable()->after('profile_image');
            $table->tinyInteger('preferedmethod')->default(0)->after('address')->comment('0-Email,1-Call,2-Text');
            $table->string('city')->nullable()->after('phone');
            $table->unsignedInteger('state_id')->nullable()->after('city');
            $table->string('zipcode')->nullable()->after('state_id');
            $table->string('last_four_ssn')->nullable()->after('birthdate');
            $table->string('unit')->nullable()->after('last_four_ssn');
            $table->text('user_bio')->nullable()->after('unit');

            $table->dropColumn('firmcode');
        });
    }
};
