<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('firms', function (Blueprint $table) {
            $table->integerIncrements('id');
            $table->string('name',255);
            $table->integer('user_id')->unsigned()->default(0);
            $table->text('address1')->nullable();
            $table->text('address2')->nullable();
            $table->string('city',255)->nullable();
            $table->integer('state_id')->unsigned()->default(0);
            $table->string('zipcode',255)->nullable();
            $table->string('country',255)->nullable()->default('US');
            $table->string('billing_name',255)->nullable();
            $table->string('billing_email',255)->nullable();
            $table->string('sameasfirm')->default(0);
            $table->text('billing_address1')->nullable();
            $table->text('billing_address2')->nullable();
            $table->string('billing_city',255)->nullable();
            $table->integer('billing_state_id')->unsigned()->default(0);
            $table->string('billing_zipcode',255)->nullable();
            $table->string('billing_country',255)->nullable()->default('US');
            $table->string('user_subscription',255)->nullable();
            $table->string('firm_size',255)->nullable();
            $table->tinyInteger('status')->default(0)->comment('0-Inactive,1-Active');
            $table->integer('created_by')->unsigned()->default(0);
            $table->integer('updated_by')->unsigned()->default(0);
            $table->timestamps();
            $table->softDeletes();
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('firms');
    }
};
