<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasTable('firms')) {
            Schema::table('firms', function (Blueprint $table) {
                $table->char('code',100)->nullable()->after('name');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasTable('firms')) {
            Schema::table('firms', function (Blueprint $table) {
                $table->dropColumn('code');
            });
        }
    }
};
