<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bars', function (Blueprint $table) {
            $table->integerIncrements('id');
            $table->string('state_name',255)->nullable();
            $table->integer('state_id')->unsigned()->default(0);
            $table->tinyInteger('voluntary_bar')->unsigned()->default(0)->comment('0-false,1-true');
            $table->tinyInteger('cle_mandatory')->unsigned()->default(0)->comment('0-false,1-true');
            $table->string('hours_needed_per_cycle')->nullable();
            $table->integer('cycle_length')->nullable()->unsigned()->default(0);
            $table->integer('general')->nullable()->unsigned()->default(0);
            $table->integer('ethics')->nullable()->unsigned()->default(0);
            $table->tinyInteger('podcast_accepted')->unsigned()->default(0)->comment('0-false,1-true');
            $table->integer('shortest_length_accepted')->nullable()->unsigned()->default(0);
            $table->text('credit_upload_method')->nullable();
            $table->tinyInteger('auto_credit_upload')->nullable()->unsigned()->default(0)->comment('0-false,1-true');
            $table->tinyInteger('status')->default(0)->comment('0-Inactive,1-Active');
            $table->integer('created_by')->unsigned()->default(0);
            $table->integer('updated_by')->unsigned()->default(0);
            $table->timestamps();
            $table->softDeletes();
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bars');
    }
};
