<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists('contents');
        Schema::create('contents', function (Blueprint $table) {
            $table->integerIncrements('id');
            $table->string('content_type',50)->nullable();
            $table->text('podcast_fields')->nullable();
            $table->string('internal_name',255)->nullable();
            $table->string('number',255)->nullable();
            $table->string('external_name',255)->nullable();
            $table->text('short_description')->nullable();
            $table->string('cl_number',255)->nullable();
            $table->string('provider_name',255)->nullable();
            $table->string('cl_type',50)->nullable();
            $table->integer('approved_state')->nullable()->unsigned()->default(0);
            $table->string('state_id',255)->nullable();
            $table->integer('length')->nullable()->unsigned()->default(0);
            $table->string('file_type',255)->nullable();
            $table->string('upload_file',255)->nullable();
            $table->string('course_type',255)->nullable();
            $table->text('prerequisites')->nullable();
            $table->dateTime('aired_on')->nullable();
            $table->tinyInteger('status')->default(0)->comment('0-Inactive,1-Active');
            $table->integer('created_by')->unsigned()->default(0);
            $table->integer('updated_by')->unsigned()->default(0);
            $table->timestamps();
            $table->softDeletes();
            $table->engine = 'InnoDB';
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contents');
    }
};
