<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        //
        Schema::table('users', function (Blueprint $table) {
            $table->string('display_name')->nullable()->after('subscription_status');
            $table->string('user_firm_name')->nullable()->after('display_name');
            $table->string('user_firm_address1')->nullable()->after('user_firm_name');
            $table->string('user_firm_address2')->nullable()->after('user_firm_address1');
            $table->string('user_firm_city')->nullable()->after('user_firm_address2');
            $table->integer('user_firm_state_id')->nullable()->after('user_firm_city');
            $table->string('user_firm_zip')->nullable()->after('user_firm_state_id');
            $table->string('user_work_email')->nullable()->after('user_firm_zip');
            $table->string('user_work_phone')->nullable()->after('user_work_email');
            $table->integer('user_practice_area')->nullable()->after('user_work_phone');
            $table->string('is_completed_profile')->nullable()->default(0)->after('user_practice_area');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('display_name');
            $table->dropColumn('user_firm_name');
            $table->dropColumn('user_firm_address1');
            $table->dropColumn('user_firm_address2');
            $table->dropColumn('user_firm_city');
            $table->dropColumn('user_firm_state');
            $table->dropColumn('user_firm_zip');
            $table->dropColumn('user_work_email');
            $table->dropColumn('user_work_phone');
            $table->dropColumn('user_practice_area');
            $table->dropColumn('is_completed_profile');
        });
    }
};
