<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasColumn('users', 'refer_code') && Schema::hasColumn('users','refer_by')) {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('refer_code');
            $table->dropColumn('refer_by');
        });
    }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('refer_code')->nullable()->after('securitycode')->comment('user refer code');
            $table->string('refer_by')->nullable()->after('status')->comment('refer by user id');
        });
    }
};
