<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('contents', function (Blueprint $table) {
            // Drop columns
            $table->dropColumn('podcast_fields');
            $table->dropColumn('external_name');
            $table->dropColumn('course_type');
            $table->dropColumn('cl_type');
            $table->dropColumn('cl_number');

            //Change column types and set defaults
            $table->text('approved_state')->nullable()->default('[]')->change();
            $table->text('state_id')->nullable()->default('[]')->change();

            // Add new columns
            $table->string('provider_type', 15)->nullable()->after('short_description');
            $table->string('credit_provided_by_the_course', 5)->nullable()->after('state_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('contents', function (Blueprint $table) {
            //
        });
    }
};
