<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('contents', function (Blueprint $table) {
            //Rename columns
            $table->renameColumn('aired_on','expire_date');
            $table->renameColumn('internal_name','podcast_title');
            $table->renameColumn('number','internal_cl_podcast_id');
            $table->renameColumn('state_id','state_bar_id');
            $table->renameColumn('approved_state','state');

            $table->string('cl_type',15)->nullable()->comment('1-General,2-Ethics,3-Dual')->after('provider_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('contents', function (Blueprint $table) {
            //
        });
    }
};
