<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('provider_users', function (Blueprint $table) {
            $table->integerIncrements('id');
            $table->string('name',50);
            $table->tinyInteger('user_type')->nullable()->comment("provider type selection is 1 = Sponsored,2 = partner")->default(1);
            $table->string('status')->default(1);
            $table->integer('created_by')->unsigned()->default(0);
            $table->integer('updated_by')->unsigned()->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('provider_users');
    }
};
