<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists('contents_states');
        Schema::create('contents_states', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('contents_id')->nullable();
            $table->unsignedInteger('state_id')->nullable();
            $table->string('credit_provided_by_the_course',10);
            $table->string('state_bar_id',25);
            $table->tinyInteger('status')->default(1)->comment('0-Inactive,1-Active');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contents_states');
    }
};
