<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('content_listeners', function (Blueprint $table) {
            $table->id();
            $table->integer('content_id')->unsigned()->default(0);
            $table->integer('content_file_id')->unsigned()->default(0);
            $table->integer('user_id')->unsigned()->default(0);
            $table->string('listen_time',20)->default("00:00");
            $table->tinyInteger('listen_status')->default(0)->comment('0-on going,1-completed');
            $table->integer('created_by')->unsigned()->default(0);
            $table->integer('updated_by')->unsigned()->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('content_listeners');
    }
};
