<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('bar_user_references', function (Blueprint $table) {
            $table->integer('is_paid')->unsigned()->comment("0=notPaid,1=Paid,2=canceled")->default(0);
            $table->integer('paid_by')->unsigned()->comment("0=Pending,1=Self,2=Firm")->default(0);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bar_user_references', function (Blueprint $table) {
            $table->dropColumn('is_paid');
            $table->dropColumn('paid_by');
        });
    }
};
