<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::table('subscriptions')->truncate();
        DB::table('user_credits')->truncate();
        DB::table('submissions')->truncate();
        DB::table('content_listeners')->truncate();

        Schema::table('subscriptions', function (Blueprint $table) {
            $table->integer('bar_user_references_id')->unsigned()->after('bar_id');
            $table->string('hours_needed_per_cycle',10)->nullable()->after('bar_user_references_id');
            $table->integer('cycle_length')->nullable()->unsigned()->default(0)->after('hours_needed_per_cycle');
            $table->integer('general')->nullable()->unsigned()->default(0)->after('cycle_length');
            $table->integer('ethics')->nullable()->unsigned()->default(0)->after('general');
            $table->string('stripe_subscription_status',20)->nullable()->after('ethics');
        });

        Schema::table('user_credits', function (Blueprint $table) {
            $table->integer('bar_id')->unsigned()->after('user_id');
            $table->integer('subscription_id')->unsigned()->default(0)->after('bar_id');
            $table->string('stripe_subscription_id')->nullable()->after('subscription_id');
        });

        Schema::table('submissions', function (Blueprint $table) {
            $table->integer('subscription_id')->unsigned()->default(0)->after('bar_id');
            $table->string('stripe_subscription_id')->nullable()->after('subscription_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
