<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            $table->string('remaining_hours_needed_per_cycle',10)->nullable()->after('ethics');
            $table->integer('remaining_general')->nullable()->unsigned()->default(0)->after('remaining_hours_needed_per_cycle');
            $table->integer('remaining_ethics')->nullable()->unsigned()->default(0)->after('remaining_general');
            $table->string('latest_invoice',20)->nullable()->after('remaining_ethics');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
