<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        //
        Schema::table('content_listeners', function (Blueprint $table) {
            $table->bigInteger('listen_time')->unsigned()->default(0)->comment('stores video length in seconds')->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
        Schema::table('content_listeners', function (Blueprint $table) {
            //
            $table->string('listen_time',20)->default("00:00")->comment('stores video length in minute seconds')->change();
        });
    }
};
