<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('submissions', function (Blueprint $table) {
            $table->tinyInteger('status')->unsigned()->default(0)->comment('0=RECEIVED,1=EXPORTED,2=SUBMITTED')->after('credit_submitted');
            $table->dateTime('exported_at')->nullable()->after('status');
            $table->dateTime('submitted_at')->nullable()->after('exported_at');
            $table->string('certificate_file')->nullable()->after('content_state_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
