<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists(table: 'releases');
        Schema::create('releases', function (Blueprint $table) {
            $table->id();
            $table->string('name',255)->nullable();
            $table->mediumText('description')->nullable();
            $table->string('version',255)->nullable();
            $table->string('image',255)->nullable();
            $table->tinyInteger('status')->default(1)->comment('0- Inactive,1-Active');
            $table->integer('created_by')->unsigned()->default(0);
            $table->integer('updated_by')->unsigned()->default(0);
            $table->timestamps();
            $table->softDeletes();
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('releases');
    }
};
