<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::dropIfExists(table: 'news');
        Schema::create('news', function (Blueprint $table) {
            $table->id();
            $table->string('title',255)->nullable();
            $table->string('slug', 255);
            $table->mediumText('description')->nullable();
            $table->string('author',255)->nullable();
            $table->string('banner',255)->nullable();
            $table->tinyInteger('status')->default(1)->comment('0- Inactive,1-Active');
            $table->integer('created_by')->unsigned()->default(0);
            $table->integer('updated_by')->unsigned()->default(0);
            $table->timestamps();
            $table->softDeletes();
            $table->engine = 'InnoDB';
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('news');
    }
};
