<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        
        $facultyOrder = [
            'Sean Martin',
            'Joel Surber',
            'Scott Lynn',
            'Adam Barber, MHPS, PLLC',
            'John Wilks, MHPS, PLLC',
            'Jonathan Farmer, Spencer Fane',
            'Amy Willoughby Bryant',
            'Cathy Speers Johnson',
            'J.K. Simms',
            'Kurt Myers',
            'Adam Dread',
            'Catherine S. Eaton Esq.',
            'Christina Stubblefield',
            'Joseph W. Fuson, Esq.',
            'Josh Offutt',
        ];

        foreach ($facultyOrder as $index => $name) {
            DB::table('faculty')
                ->whereRaw('TRIM(name) = ?', [trim($name)])
                ->update(['display_order' => $index + 1]);
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
