<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::table('archives')->insert([
            'comment' => 'CL-7 (Duplicate records with different submitted credits for user found on Production.)\nSubmissions entry deleted for "David Weissman" for duplicate entry of podcast "Collaborative Divorce Roundtable - Sean Martin, Joel Surber; fans, friends and members ',
            'data' => json_encode([
                [
                    "type" => "header",
                    "version" => "5.2.1",
                    "comment" => "Export to JSON plugin for PHPMyAdmin"
                ],
                ["type" => "database", "name" => "clearlylegal_production"],
                [
                    "type" => "table",
                    "name" => "submissions",
                    "database" => "clearlylegal_production",
                    "data" => [
                        [
                            "id" => "622",
                            "user_id" => "433",
                            "bar_id" => "10",
                            "subscription_id" => "129",
                            "stripe_subscription_id" => "sub_1QdJ5rLxZMidFajO9KdBTRfb",
                            "content_id" => "69",
                            "content_file_id" => "175",
                            "content_state_id" => "69",
                            "certificate_file" => null,
                            "credit_submitted" => "0.50",
                            "status" => "2",
                            "exported_at" => "2025-01-06 11:36:49",
                            "submitted_at" => "2025-01-08 14:26:31",
                            "created_by" => "433",
                            "updated_by" => "433",
                            "created_at" => "2025-01-04 02:12:14",
                            "updated_at" => "2025-01-08 19:56:31",
                            "deleted_at" => null
                        ]
                    ]
                ]
            ]),
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('submissions')
            ->where('user_id', 433)
            ->where('content_id', 69)
            ->where('id', 622)
            ->update(['deleted_at' => now()]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
