<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('podcast_statistics', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('content_id');
            $table->unsignedBigInteger('content_file_id');
            $table->unsignedBigInteger('android');
            $table->unsignedBigInteger('iphone');
            $table->unsignedBigInteger('web');
            $table->unsignedBigInteger('home_page');
            $table->unsignedBigInteger('library');
            $table->longText('site_name');
            $table->longText('token');
            $table->longText('key');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('podcast_statistics');
    }
};
