<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('qrcode_events', function (Blueprint $table) {
            $table->id();
            $table->string('uuid')->nullable();
            $table->text('event_name')->nullable();
            $table->text('description')->nullable();
            $table->longText('qr_endpoint')->nullable();
            $table->boolean('status');
            $table->integer('created_by');
            $table->integer('updated_by');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('qr_code_events');
    }
};
