<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('qrcode_statistics', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('event_id')->nullable();
            $table->string('event_uuid')->nullable();
            $table->text('client_user_agent')->nullable();
            $table->string('client_browser')->nullable();
            $table->string('client_ipaddress')->nulevntlable();
            $table->string('client_platform')->nullable();
            $table->bigInteger('scan_attempts');
            $table->longText('session_key');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('table_qr_code_scans');
    }
};
