<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $uuid=str_random(10);
        DB::table('qrcode_events')
        ->insert([
            'uuid'=>$uuid,
            'event_name'=>"CL QR Scanner",
            'description'=>"CL QR code scanner for conf 2025",
            'qr_endpoint'=>env('APP_URL')."/subscribe/$uuid",
            'status'=>1,
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
