<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('faculty_inquiries', function (Blueprint $table) {
            $table->id();
            $table->string('first_name', 25);
            $table->string('last_name', 25);
            $table->string('phone_number', 25);
            $table->string('email', 100);
            $table->string('bio_link')->nullable();
            $table->string('firm_name')->nullable();
            $table->string('ip_address', 45)->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
        Schema::create('category_faculty_inquiry', function (Blueprint $table) {
            $table->foreignId('category_id')->constrained();
            $table->foreignId('faculty_inquiry_id')->constrained();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('faculty_inquiries');
    }
};