<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('menu', function (Blueprint $table) {
            $timeStamp = now();

        DB::table('menus')->insert([
                [
                    'title' => 'FAQs',
                    'route_name' => 'faqs.index',
                    'params' => null,
                    'icon' => 'icon-dashboard-icon',
                    'imageurl' => 'assets/admin/images/cms/dashboard.svg',
                    'type' => 'Admin',
                    'parent_id' => 0,
                    'display_order' => 7,
                    'status' => true,
                    'created_by' => 1,
                    'updated_by' => 1,
                    'created_at' => $timeStamp,
                    'updated_at' => $timeStamp
                ],
            ]);
            $websiteId = DB::table('menus')->where('title', 'Website')->value('id');
            DB::table('menus')->where('title', 'FAQs')->update(['parent_id' => $websiteId]);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('menus', function (Blueprint $table) {
            //
        });
    }
};
