<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddIndexesToContentAndRelatedTables extends Migration
{
    public function up()
    {
        Schema::table('contents', function (Blueprint $table) {
            $table->index(['status', 'expire_date'], 'idx_status_expiredate');
            $table->index('published_on', 'idx_published_on');
            $table->index('category_id', 'idx_category_id');
            $table->index('cl_type', 'idx_cl_type');
        });

        Schema::table('contents_states', function (Blueprint $table) {
            $table->index(['bar_id', 'contents_id'], 'idx_barid_contentsid');
        });

        Schema::table('faculty', function (Blueprint $table) {
            $table->index(['id', 'status'], 'idx_id_status');
        });
    }

    public function down()
    {
        Schema::table('contents', function (Blueprint $table) {
            $table->dropIndex('idx_status_expiredate');
            $table->dropIndex('idx_published_on');
            $table->dropIndex('idx_category_id');
            $table->dropIndex('idx_cl_type');
        });

        Schema::table('contents_states', function (Blueprint $table) {
            $table->dropIndex('idx_barid_contentsid');
        });

        Schema::table('speakers', function (Blueprint $table) {
            $table->dropIndex('idx_id_status');
        });
    }
}

