<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('content_listeners', function (Blueprint $table) {
            $table->index('user_id');
            $table->index('content_id');
            $table->index('content_file_id');
            $table->index('completed_at');
            $table->index(['user_id', 'content_id']);
            $table->index(['user_id', 'content_id', 'content_file_id']);
            $table->index('listen_status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('content_listeners', function (Blueprint $table) {
            //
        });
    }
};
