<?php
namespace Database\Seeders;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CreateDefaultUserTypes extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Disable foreign key check to truncating the table
        DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        // Truncate User types
        DB::table('user_types')->truncate();
        $timeStamp = date('Y-m-d h:i:s');
        // Default User types
        $userTypes = [
            [
                'title' => 'Admin',
                'shortname' => 'superadmin',
                'status' => 1,
                'created_by' => 1,
                'updated_by' => 1,
                'created_at' => $timeStamp,
                'updated_at' => $timeStamp
            ],
            [
                'title' => 'Firm Admin',
                'shortname' => 'admin',
                'status' => 1,
                'created_by' => 1,
                'updated_by' => 1,
                'created_at' => $timeStamp,
                'updated_at' => $timeStamp
            ],
            [
                'title' => 'App Users',
                'shortname' => 'student',
                'status' => 1,
                'created_by' => 1,
                'updated_by' => 1,
                'created_at' => $timeStamp,
                'updated_at' => $timeStamp
            ],
        ];

        foreach ($userTypes as $data) {
            DB::table('user_types')->insert($data);
        }
    }
}
