<?php

use Illuminate\Database\Seeder;

class DefaultPageSeeder extends Seeder {

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run() {
        // Default Page data
        $pageData = [
            [
                'title' => 'Online Electrical Continuing Education',
                'slug' => 'about-us',
                'meta_title' => 'LIGHTWAVE LEARNING',
                'meta_desc' => 'LIGHTWAVE LEARNING',
                'description' => '<h2 class="mb-3">LIGHTWAVE LEARNING</h2>
                <p class="mt-3">Clearly Legal provides affordable online state-approved electrical continuing education courses for all Electricians and Electrical Professionals, Courses are straightforward in design, meant to further improve one\'s knowledge of the NEC/electrical theory.</p>
                <h4 class="mt-3">All CE Course Enrollments are FREE</h4>
                <div class="position-relative mt-3"><a class="btn btn-theme-all pl-5 pr-5 py-2" title="login" href="/login">EXISTING USERS LOGIN</a></div>
                <h5 class="mt-3">Pay after course is Passed!</h5>',
                'status' => '1',
                'created_by' => 1,
                'updated_by' => 1,
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'title' => '4-Hour Courses for $29',
                'slug' => 'courseinfoblock',
                'meta_title' => 'Courseinfo',
                'meta_desc' => 'Courseinfo',
                'description' => '<h2 class="text-center mb-4">Start Today</h2>
                <div class="list-course">
                <ul class="list-group list-group-flush">
                <li class="list-group-item">Select Desired State</li>
                <li class="list-group-item">Choose Desired Course</li>
                <li class="list-group-item">Create Your Account</li>
                <li class="list-group-item">Start Your Selected Course</li>
                <li class="list-group-item">Pay for Course When Passed</li>
                </ul>
                </div>',
                'status' => '1',
                'created_by' => 1,
                'updated_by' => 1,
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'title' => 'Feature',
                'slug' => 'homefeatureblock',
                'meta_title' => 'Feature',
                'meta_desc' => 'Feature',
                'description' => '<div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col-12 px-1" data-aos="fade-up">
                <div class="card-features position-relative shadow-sm  bg-white rounded">
                <figure class="position-relative d-flex justify-content-center"><img src="/assets/front/images/best-value.svg" alt="Best Value" width="60" /></figure>
                <h4>Best Value</h4>
                <p>Our prices are always competitive while striving to provide an excellent product and customer service.</p>
                </div>
                </div>
                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col-12 px-1" data-aos="fade-up">
                <div class="card-features position-relative shadow-sm  bg-white rounded">
                <figure class="position-relative d-flex justify-content-center"><img src="/assets/front/images/best-value.svg" alt="Best Value" width="60" /></figure>
                <h4>Pay After Course is Passed</h4>
                <p>Feel free to sample our courses. Pay After Course is Passed.</p>
                </div>
                </div>
                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col-12 px-1" data-aos="fade-up">
                <div class="card-features position-relative shadow-sm  bg-white rounded">
                <figure class="position-relative d-flex justify-content-center"><img src="/assets/front/images/best-value.svg" alt="Best Value" width="50" /></figure>
                <h4>Fast Reporting</h4>
                <p>Passed courses are reported the next business day once payment is made.</p>
                </div>
                </div>
                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col-12 px-1" data-aos="fade-up">
                <div class="card-features position-relative shadow-sm  bg-white rounded">
                <figure class="position-relative d-flex justify-content-center"><img src="/assets/front/images/best-value.svg" alt="Best Value" width="60" /></figure>
                <h4>Free Multi-State</h4>
                <p>Don\'t pay more because you have multiple licenses; we\'ll help you out!</p>
                </div>
                </div>
                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col-12 px-1" data-aos="fade-up">
                <div class="card-features position-relative shadow-sm  bg-white rounded">
                <figure class="position-relative d-flex justify-content-center"><img src="/assets/front/images/best-value.svg" alt="Best Value" width="60" /></figure>
                <h4>Mobile Friendly</h4>
                <p>Access your chosen course on desktop/laptop/tablet/ or smartphone.</p>
                </div>
                </div>
                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col-12 px-1" data-aos="fade-up">
                <div class="card-features position-relative shadow-sm  bg-white rounded">
                <figure class="position-relative d-flex justify-content-center"><img src="/assets/front/images/best-value.svg" alt="Best Value" width="60" /></figure>
                <h4>No Code Book Needed</h4>
                <p>Although we encourage the use of a Code Book, one is not required for course completion.</p>
                </div>
                </div>',
                'status' => '1',
                'created_by' => 1,
                'updated_by' => 1,
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'title' => 'Homevideoblock',
                'slug' => 'homevideoblock',
                'meta_title' => 'Homevideoblock',
                'meta_desc' => 'Homevideoblock',
                'description' => '<p><video src="/assets/front/images/LightWave.mp4" loop="loop" controls="controls"></video></p>',
                'status' => '1',
                'created_by' => 1,
                'updated_by' => 1,
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'title' => 'Hours',
                'slug' => 'contacttimeingblock',
                'meta_title' => 'Contact timing block',
                'meta_desc' => 'Contact timing block',
                'description' => '<div>
                <table class="bordered">
                <tbody>
                <tr>
                <td>Monday</td>
                <td class="text-right">8:00 AM - 5:00 PM</td>
                </tr>
                <tr>
                <td>Tuesday</td>
                <td class="text-right">8:00 AM - 5:00 PM</td>
                </tr>
                <tr>
                <td>Wednesday</td>
                <td class="text-right">8:00 AM - 5:00 PM</td>
                </tr>
                <tr>
                <td>Thursday</td>
                <td class="text-right">8:00 AM - 5:00 PM</td>
                </tr>
                <tr>
                <td>Friday</td>
                <td class="text-right">8:00 AM - 5:00 PM</td>
                </tr>
                <tr>
                <td class="text-danger">Saturday</td>
                <td class="text-danger text-right">Closed</td>
                </tr>
                <tr>
                <td class="text-danger">Sunday</td>
                <td class="text-danger text-right">Closed</td>
                </tr>
                <tr>
                <td class="text-danger">Major Holidays</td>
                <td class="text-danger text-right">Closed</td>
                </tr>
                </tbody>
                </table>
                </div>',
                'status' => '1',
                'created_by' => 1,
                'updated_by' => 1,
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'title' => 'About Us',
                'slug' => 'contactaboutusblock',
                'meta_title' => 'Contact aboutus block',
                'meta_desc' => 'Contact aboutus block',
                'description' => '<div>
                <h6>Online Electrical Continuing Education</h6>
                <h3>Clearly Legal</h3>
                <p>At Clearly Legal, our primary purpose is to be a resource for the electrician. We aim to designed courses
                with concise content delivered in an easy-to-follow fashion on an intuitively created online platform, all at an
                affordable cost to the end-user.</p>
                </div>',
                'status' => '1',
                'created_by' => 1,
                'updated_by' => 1,
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
        ];
        
        // Default pages            
          

        foreach ($pageData as $data) {
            DB::table('pages')->insert($data);
        }
    }

}
