<?php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DefaultSetupSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Disable foreign key check to truncating the table
        DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        // Truncate User types
        DB::table('user_types')->truncate();
        // Default User types
        $userTypes = [
            [
                'title' => 'Super Admin',
                'status' => 1,
                'created_by' => 1,
                'updated_by' => 1,
            ],
            [
                'title' => 'Admin',
                'status' => 1,
                'created_by' => 1,
                'updated_by' => 1,
            ],
            [
                'title' => 'Front',
                'status' => 1,
                'created_by' => 1,
                'updated_by' => 1,
            ]
        ];

        foreach ($userTypes as $data) {
            DB::table('user_types')->insert($data);
        }

        //add one default admin user
        DB::table('users')->insert([
            'user_type_id' => 1,
            'email' => 'nirmal.patel@kernelequity.com',
            'password' => '$2y$10$qDsPIvlkL1939WBXVZ3Z7.t/Pg82f07hjBI7ldmTA6a4yIdcoN44e',
            'first_name' => 'Admin',
            'last_name'=> 'User',
            'email_verified_at'=> \Carbon\Carbon::now(),
            'created_at' => \Carbon\Carbon::now(),
            'updated_at' => \Carbon\Carbon::now(),
            'status' => 1,
            'created_by' => 1,
            'updated_by' => 1,
        ]);

        // Disable foreign key check to truncating the table
        DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        // Insert predefined Site config data
        DB::table('site_configs')->truncate();

        $contactEmail = 'contact@laravelcms.com';
        // Default Site config data
        $siteConfigData = [
            [
                'name' => 'app_name',
                'val' => 'Kernel Equity',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'records_per_page',
                'val' => '100',
                'status' => 1,
                'type' => 'int',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'footer_title_for_admin',
                'val' => 'Kernel Equity',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'site_title',
                'val' => 'Kernel Equity',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'tagline',
                'val' => '',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'copyright_text',
                'val' => '© Copyright',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'company_name',
                'val' => 'Kernel Equity',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'meta_description_for_front',
                'val' => 'Kernel Equity',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'company_address_line1',
                'val' => 'Test',
                'status' => 0,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'company_address_line2',
                'val' => '',
                'status' => 0,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'company_city',
                'val' => 'Test',
                'status' => 0,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'company_state',
                'val' => 'Nashville',
                'status' => 0,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'company_country',
                'val' => 'United States',
                'status' => 0,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'company_zipcode',
                'val' => '11111',
                'status' => 0,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'company_email',
                'val' => '',
                'status' => 0,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'phone',
                'val' => '123-456-789',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'email',
                'val' => 'test@gmail.com',
                'status' => 1,
                'type' => 'email',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'from_name',
                'val' => 'Kernel Equity',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'from_email',
                'val' => $contactEmail,
                'status' => 1,
                'type' => 'email',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'admin_email',
                'val' => $contactEmail,
                'status' => 1,
                'type' => 'email',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'robots_meta_tag',
                'val' => '<meta name="robots" content="noindex, nofollow" />',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'google_analytics_code',
                'val' => '',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'google_tag_manager_code',
                'val' => '',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'googlemap_embedded',
                'val' => '<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3690.9474617286137!2d73.16650917600124!3d22.317826642258584!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x395fc99193557c75%3A0x43f0b7a7c4b7a29d!2sKernelEquity%20Technologies%20Pvt%20Ltd!5e0!3m2!1sen!2sin!4v1719207075939!5m2!1sen!2sin" width="600" height="310" frameborder="0" style="border:0;" allowfullscreen=""></iframe>',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'facebook_link',
                'val' => '',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'twitter_link',
                'val' => '',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'linkedin_link',
                'val' => '',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'contact_title',
                'val' => 'Contact',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'contact_sub_title',
                'val' => 'Any questions?',
                'status' => 0,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'contact_thank_you_message',
                'val' => 'Thank you for contacting us. We will respond to you as soon as possible.',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'contact_email',
                'val' => $contactEmail,
                'status' => 1,
                'type' => 'email',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'user_contact_acknowledge',
                'val' => 'No',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'logo',
                'val' => '',
                'status' => 1,
                'type' => 'file',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'GOOGLE_RECAPTCHA_KEY',
                'val' => '',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'GOOGLE_RECAPTCHA_SECRET',
                'val' => '',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'footer_meta_title_for_admin',
                'val' => 'Laravel CMS',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'meta_title_for_front',
                'val' => 'Laravel CMS',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'password_strength',
                'val' => 'Easy',
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'login_attempt',
                'val' => 3,
                'status' => 1,
                'type' => 'int',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'minimum_password_length',
                'val' => '8',
                'status' => 1,
                'type' => 'int',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'user_block_time',
                'val' => '3',
                'status' => 1,
                'type' => 'int',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'androidRedirectLinkCount',
                'val' => 0,
                'status' => 1,
                'type' => 'int',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'iosRedirectLinkCount',
                'val' => 0,
                'status' => 1,
                'type' => 'int',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'unsupportedRedirectLinkCount',
                'val' => 0,
                'status' => 1,
                'type' => 'int',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'android_app_id',
                'val' => "",
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ],
            [
                'name' => 'ios_app_id',
                'val' => "",
                'status' => 1,
                'type' => 'string',
                'created_at' => \Carbon\Carbon::now(),
                'updated_at' => \Carbon\Carbon::now(),
            ]
        ];

        foreach ($siteConfigData as $data) {
            DB::table('site_configs')->insert($data);
        }
    }
}
