<?php

namespace Database\Seeders;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Seeder;

class MenuTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $timeStamp = '2019-10-29 18:30:00';
        $titleViewAll = 'View All';
        $menu = array(
            array('title' => 'Dashboard',
                'route_name' => 'dashboard',
                'params' => null,
                'icon' => 'icon-dashboard-icon',
                'imageurl' => 'assets/admin/images/cms/dashboard.svg',
                'type' => 'Admin',
                'parent_id' => '0',
                'display_order' => '1',
                'status' => '1',
                'created_by' => '1',
                'updated_by' => '1',
                'created_at' => $timeStamp,
                'updated_at' => $timeStamp
            ),

            array('title' => 'Users',
                'route_name' => 'user.index',
                'params' => null,
                'icon' => 'icon-person-icon',
                'imageurl' => 'assets/admin/images/cms/user.svg',
                'type' => 'Admin',
                'parent_id' => '0',
                'display_order' => '2',
                'status' => '1',
                'created_by' => '1',
                'updated_by' => '1',
                'created_at' => $timeStamp,
                'updated_at' => $timeStamp
            ),

            array('title' => 'Admin Users',
                'route_name' => 'user.index',
                'params' => null,
                'icon' => 'icon-person-icon',
                'imageurl' => 'assets/admin/images/cms/user.svg',
                'type' => 'Admin',
                'parent_id' => '2',
                'display_order' => '2',
                'status' => '1',
                'created_by' => '1',
                'updated_by' => '1',
                'created_at' => $timeStamp,
                'updated_at' => $timeStamp
            ),
            array('title' => 'App Users',
                'route_name' => 'student.list',
                'params' => null,
                'icon' => 'icon-person-icon',
                'imageurl' => 'assets/admin/images/cms/user.svg',
                'type' => 'Admin',
                'parent_id' => '2',
                'display_order' => '2',
                'status' => '1',
                'created_by' => '1',
                'updated_by' => '1',
                'created_at' => $timeStamp,
                'updated_at' => $timeStamp
            ),
            array('title' => 'Pages',
                'route_name' => 'page.index',
                'params' => null,
                'icon' => 'icon-files-empty',
                'imageurl' => 'assets/admin/images/cms/pages.svg',
                'type' => 'Admin',
                'parent_id' => '0',
                'display_order' => '7',
                'status' => '1',
                'created_by' => '1',
                'updated_by' => '1',
                'created_at' => $timeStamp,
                'updated_at' => $timeStamp
            ),
            array('title' => 'Firm',
                'route_name' => 'firm.index',
                'params' => null,
                'icon' => 'icon-files-empty',
                'imageurl' => 'assets/admin/images/cms/firm.svg',
                'type' => 'Admin',
                'parent_id' => '0',
                'display_order' => '7',
                'status' => '1',
                'created_by' => '1',
                'updated_by' => '1',
                'created_at' => $timeStamp,
                'updated_at' => $timeStamp
            ),
            array('title' => 'Bars',
                'route_name' => 'bar.index',
                'params' => null,
                'icon' => 'icon-files-empty',
                'imageurl' => 'assets/admin/images/cms/bar.svg',
                'type' => 'Admin',
                'parent_id' => '0',
                'display_order' => '7',
                'status' => '1',
                'created_by' => '1',
                'updated_by' => '1',
                'created_at' => $timeStamp,
                'updated_at' => $timeStamp
            ),
            array('title' => 'Content Management',
                'route_name' => 'content.index',
                'params' => null,
                'icon' => 'icon-files-empty',
                'imageurl' => 'assets/admin/images/cms/contents.svg',
                'type' => 'Admin',
                'parent_id' => '0',
                'display_order' => '7',
                'status' => '1',
                'created_by' => '1',
                'updated_by' => '1',
                'created_at' => $timeStamp,
                'updated_at' => $timeStamp
            ),
            array('title' => 'Submissions',
                'route_name' => 'submissions.index',
                'params' => null,
                'icon' => 'icon-files-empty',
                'imageurl' => 'assets/admin/images/cms/submissions.svg',
                'type' => 'Admin',
                'parent_id' => '0',
                'display_order' => '8',
                'status' => '1',
                'created_by' => '1',
                'updated_by' => '1',
                'created_at' => $timeStamp,
                'updated_at' => $timeStamp
            ),
            array('title' => 'Subscriptions',
                'route_name' => 'subscriptions.index',
                'params' => null,
                'icon' => 'icon-files-empty',
                'imageurl' => 'assets/admin/images/cms/subscriptions.svg',
                'type' => 'Admin',
                'parent_id' => '0',
                'display_order' => '8',
                'status' => '1',
                'created_by' => '1',
                'updated_by' => '1',
                'created_at' => $timeStamp,
                'updated_at' => $timeStamp
            ),
            array('title' => 'Support Inquires',
                'route_name' => 'support.index',
                'params' => null,
                'icon' => 'icon-files-empty',
                'imageurl' => 'assets/admin/images/cms/support.svg',
                'type' => 'Admin',
                'parent_id' => '0',
                'display_order' => '8',
                'status' => '1',
                'created_by' => '1',
                'updated_by' => '1',
                'created_at' => $timeStamp,
                'updated_at' => $timeStamp
            ),
            array('title' => 'IP Tracker',
                'route_name' => 'iptracker.index',
                'params' => null,
                'icon' => 'icon-settings-icon',
                'imageurl' => 'assets/admin/images/cms/iptracker.svg',
                'type' => 'Admin',
                'parent_id' => '0',
                'display_order' => '13',
                'status' => '1',
                'created_by' => '1',
                'updated_by' => '1',
                'created_at' => $timeStamp,
                'updated_at' => $timeStamp
            ),
            array('title' => 'Contact us',
                'route_name' => 'contact-us.index',
                'params' => null,
                'icon' => 'icon-files-empty',
                'imageurl' => 'assets/admin/images/cms/contact.svg',
                'type' => 'Admin',
                'parent_id' => '0',
                'display_order' => '199',
                'status' => '1',
                'created_by' => '1',
                'updated_by' => '1',
                'created_at' => $timeStamp,
                'updated_at' => $timeStamp
            ),
            array('title' => 'Settings',
                'route_name' => 'site-config',
                'params' => 'a:1:{s:6:"module";s:6:"global";}',
                'icon' => 'icon-settings-icon',
                'imageurl' => 'assets/admin/images/cms/setting.svg',
                'type' => 'Admin',
                'parent_id' => '0',
                'display_order' => '200',
                'status' => '1',
                'created_by' => '1',
                'updated_by' => '1',
                'created_at' => $timeStamp,
                'updated_at' => $timeStamp
            ),
        );
        DB::table('menus')->truncate();
        foreach ($menu as $data) {
            DB::table('menus')->updateOrInsert($data);
        }
    }
}
