<?php

namespace Database\Seeders;

use App\PracticeArea;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PacticeAreaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('practice_areas')->truncate();
        $timeStamp = date('Y-m-d h:i:s');
        $areas = ['Administrative Law','Civil Litigation Law','Bankruptcy Law','Criminal Law','Employment Law','Family Law','Personal Injury Law','Business and Compliance','Elder Law','Estate Planning Law','Immigration Law','Intellectual Property Law','Real Estate Law','Government Law','In-House Counsel','General Practice'];

        foreach ($areas as $area) {
            $param = [
                'name' => $area,
                'created_at' => $timeStamp,
                'updated_at' => $timeStamp
            ];
            PracticeArea::insert($param);
        }
    }
}
