<?php
namespace Database\Seeders;
use App\State;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class StateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('states')->truncate();
        $timeStamp = date('Y-m-d h:i:s');
        $states = ['Alabama
        ', 'Alaska
        ', 'Arizona
        ', 'Arkansas
        ', 'California
        ', 'Colorado
        ', 'Connecticut
        ', 'Delaware
        ', 'District of Columbia
        ', 'Florida
        ', 'Georgia
        ', 'Hawaii
        ', 'Idaho
        ', 'Illinois
        ', 'Indiana
        ', 'Iowa
        ', 'Kansas
        ', 'Kentucky
        ', 'Louisiana
        ', 'Maine
        ', 'Maryland
        ', 'Massachusetts
        ', 'Michigan
        ', 'Minnesota
        ', 'Mississippi
        ', 'Missouri
        ', 'Montana
        ', 'Nebraska
        ', 'Nevada
        ', 'New Hampshire
        ', 'New Jersey
        ', 'New Mexico
        ', 'New York
        ', 'North Carolina
        ', 'North Dakota
        ', 'Ohio
        ', 'Oklahoma
        ', 'Oregon
        ', 'Pennsylvania
        ', 'Rhode Island
        ', 'South Carolina
        ', 'South Dakota
        ', 'Tennessee
        ', 'Texas
        ', 'Utah
        ', 'Vermont
        ', 'Virginia
        ', 'Washington
        ', 'West Virginia
        ', 'Wisconsin
        ', 'Wyoming
        ', ''];

        foreach ($states as $state) {
            $param = [
                'name' => $state,
                'status' => '1',
                'created_at' => $timeStamp,
                'updated_at' => $timeStamp
            ];
            State::insert($param);
        }
    }
}
