blockID = null;
var urlPattern = /^(http|https):\/\/[^ "]+$/;
var timeoutId;
$(document).on("click", ".js-save-block-data", function () {
    var currentBlock = $(this).attr('value');
    var id = 'js-block-'+currentBlock;
    beforeBlockSaving(this);
    data = {
        id: currentBlock,
        content: $("#"+id).find("form").html(),
        
    };
    
    saveBlockData(save_lesson_url, data, false);
});

function beforeBlockSaving(element){
    $(element).closest("form").find('[name^="mce_"]').each(function(){
        $(this).remove();
    });
    $(element).closest("form").find('[name^="question"]').each(function(){
        if($(this).attr('type') == 'hidden'){
            $(this).remove();
        }
    });
    $(element).closest("form").find("[id^='answer-buttons']").find('.js-quiz-select').each(function(){
            $(this).removeClass('bg-active');
    });
    
    $(element).closest("form").find('.js-configuration-data').html('');
    if($("[id^='submit-button-']").length ){
        $("[id^='submit-button-']").each(function(){
            var blockid = $(this).attr('id').replace('submit-button-','');
            $('#submit-button-'+blockid).show();
            if($('#resELe').length){ $('#resELe').remove(); }
            $("#answer-buttons-"+blockid).find('.form-check-input').each(function(){
                $(this).removeClass('incorrect').removeClass('correct');
                $(this).parent().removeClass('incorrect').removeClass('correct');
                $(this).prop('checked', false);
                $(this).prop('disabled', false);
            });
        });
    }
}

hideShowSort();
function hideShowSort() {
    $(".js-block").find(".js-up").removeClass("d-none");
    $(".js-block").find(".js-down").removeClass("d-none");
    $(".js-block").first().find(".js-up").addClass("d-none");
    $(".js-block").last().find(".js-down").addClass("d-none");
}

$(document).on("click", ".js-delete", function () {
    var id = $(this).attr("value");
    var refernceBlock = $('#js-block-'+id).find('.container');
    $('#confirm-courseblock-delete').removeAttr('data-value').attr('data-value',id);
    $("#courseblock-confirm-action").modal("show");
});

$('body').on('click','#confirm-courseblock-delete',function(){ 
    var id = $(this).attr("data-value");
    var lesson_id = $('#block-main').attr('data-lesson');
    var currentBlock = $('#js-block-'+id);
    $('#blockmessage').find('span').html('');
    $("#courseblock-confirm-action").modal("hide");
    $.ajax({
        type: "get",
        url: delete_block_url + "?id=" + id+"&lesson_id="+lesson_id,
        beforeSend: function (xhr) {
            xhr.setRequestHeader("X-CSRF-Token", csrf_token);
        },
        success: function (data) {
            $(currentBlock).remove();
            hideShowSort();
            var i = 1;
            $('.js-block').each(function(){
                $(this).attr('data-order',i);
                i++;
            });
            $('.js-block:last').removeClass('last').addClass('last');
            $('#blockmessage').removeClass('hide').addClass('show').find('span').addClass('text-success').html(data.message);
            clearTimeout(timeoutId);
            timeoutId = setTimeout(function() {
                $('#blockmessage').addClass('hide').removeClass('show').find('span').removeClass('text-success');
            }, 6000);
        },
        error: function (response) {
            if(response.status == 401 || response.status == 419){
                window.location.href = login_url;
            }
        }
    });
});
$(document).on("change", ".js-upload-assets", function () {
    $('.error-message').html('');
    var currentBlock = $(this);
    control = $("#js-block-" + blockID)
        .find(".js-main-content")
        .find(".js-control");
    formData = new FormData();
    formData.append("file", $(this)[0].files[0]);
    formData.append("folder", $(this).attr("folder"));
    formData.append("size", $(this).attr("size"));
    formData.append("extension", $(this).attr("extension"));

    $.ajax({
        url: upload_url,
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        dataType: "json",
        beforeSend: function (xhr) {
            xhr.setRequestHeader("X-CSRF-Token", csrf_token);
        },
        success: function (response) {
            $("#js-block-" + blockID)
                .find("source")
                .attr("src", response.location);
            control[0].pause();
            control[0].load();
        },
        error: function (response) {
            if(response.status == 401 || response.status == 419){
                window.location.href = login_url;
            }
            if (typeof response.responseJSON.errors.file != "undefined") {
                var error_message = "";
                $.each(
                    response.responseJSON.errors.file,
                    function (index, value) {
                        error_message += value + "<br/>";
                    }
                );
                $('.error-message').html(error_message);
            }
        },
    });
});
$(document).on("click", ".js-sorting", function (e) {
    var data = {};
    var blockData = $(this).closest(".js-block");
    var currentBlock = $(this).attr("value");
    $("#js-block-" + currentBlock).find("form").find('[name^="mce_"]').each(function(){
        $(this).remove();
    });
    $("#js-block-" + currentBlock).find("form").find('[name^="question-container-"]').each(function(){
        $(this).remove();
    });
    $("#js-block-" + currentBlock).find("form").find('.js-configuration-data').html('');
    var blockContent = $("#js-block-" + currentBlock).clone();
    if ($(this).hasClass("js-up")) {
        var divID = $("#js-block-" + currentBlock)
            .prev(".js-block")
            .attr("id");
        console.log("UP", divID);
        $(blockContent).insertBefore("#" + divID);
    } else {
        var divID = $("#js-block-" + currentBlock)
            .next(".js-block")
            .attr("id");
        $(blockContent).insertAfter("#" + divID);
    }
    $($(blockData)).remove();
    $("#js-content-module form").each(function (index) {
        data[index] = $(this).find(".js-course-block-id").val();
    });
    $.ajax({
        type: "post",
        url: sort_lesson_url,
        data: { data: data },
        beforeSend: function (xhr) {
            xhr.setRequestHeader("X-CSRF-Token", csrf_token);
        },
        success: function (data) {
            /* $('#block-main').html(data.content);
            if($("#add_sort_order")){
                $("#add_sort_order").remove();
            }
            hideShowSort();
            loadAllVideo();
            EditorInit(); */
            $('#blockmessage').removeClass('hide').addClass('show').find('span').addClass('text-success').html(data.message);
            clearTimeout(timeoutId);
            timeoutId = setTimeout(function() {
                $('#blockmessage').addClass('hide').removeClass('show').find('span').removeClass('text-success');
            }, 6000);
            hideShowSort();
            $("#js-block-" + currentBlock).find('.btn-position-add').remove();
            $("#js-block-" + currentBlock).find('.js-configuration-data').removeClass('d-block');
            
            EditorInit();
        },
        error: function(xhr, status, error){
            console.log(xhr.status);
            if(xhr.status == 401 || xhr.status == 419){
                window.location.href = login_url;
            }
        }
    });
    e.preventDefault();
});

$(document).on("click", ".js-save", function () {
    beforeBlockSaving(this);
    data = $(this).closest("form").serializeArray();
   
    saveBlockData(save_lesson_url, data, false);
});
courseBlock = null;

//save settings
$(document).on("click", ".js-settings", function (e) {
    courseBlock = $(this);
    blockID = $(courseBlock).closest("form").find(".js-course-block-id").val();
    currentBlock = $('#js-block-'+blockID);
    refernceBlock = $(currentBlock).find('form').find('.container');
    $("#presetColors").prepend("<option value='transparent'>Transparent</option>");

  // Set the default value of the color picker to transparent
  $("[name='background-color']").val("transparent");

    configuration = $(refernceBlock)
        .find(".row")
        .css([
            "padding-top",
            "padding-bottom",
        ]);
    configurationmain = $(currentBlock)
       .css([
            "background-color",
            "background-image",
        ]);
    $("[name='padding-top']").val(0);
    $("[name='padding-bottom']").val(0);
    $("[name='background-color']").val("transparent");
    blockName = $(this).attr("js-block-name");
    
    if (configuration != undefined) {
        $.each(configuration, function (index, value) {
            if (index != "background-color") {
                $("[name='" + index + "']").val(value);
            }
        });
    }
    if (configurationmain != undefined) {
        $.each(configurationmain, function (index, value) {
            $("[name='" + index + "']").val(value);
            if (index == "background-color") {
                if (value.indexOf("rgba") > -1) {
                    $("[name='" + index + "']").val(
                        "transparent"  
                    );
                } else {
                    value = value.replace("rgb(", "");
                    value = value.replace(")", "");
                    value = value.split(", ");
                    $("[name='" + index + "']").val(
                        "#" + fullColorHex(value[0], value[1], value[2])
                    );
                }
            }
        });
    }
    $('.js-tab-content').addClass('d-none');
    switch (blockName) {
        case "audio":
            $(".js-upload-assets").attr("folder", blockName);
            $(".js-upload-assets").attr("name", blockName);
            $(".js-upload-assets").attr("extension", blockName);
            $(".js-upload-assets").attr("extension", "mp3,wav,ogg");
            $("#" + blockName + "content").removeClass("d-none");
            $(".js-multimedia-setting").removeClass("d-none");
            $("#backgroundcolorselection").removeClass("d-none");
            $("[name='audio']").val('');
            //caption text 
            var captionText = $('#js-block-'+blockID).find('.audio-caption-'+blockID).text();
            $('#audiocontent').find('.caption-text').val(captionText);

            break;
        case "video":
            $("#" + blockName + "content").removeClass("d-none");
            $(".js-multimedia-setting").removeClass("d-none");
            $("[name='video']").val('');
            $(".error-message").html('');
            $("#backgroundcolorselection").removeClass("d-none");
            break;
        case "accordion":
            accordionContentTab(blockID);
            $("#" + blockName + "content").removeClass("d-none");
            $(".js-multimedia-setting").removeClass("d-none");
            $("#backgroundcolorselection").removeClass("d-none");
            break;
        case "quiz1":
        case "quiz2":
            quizContentTab(blockID);
            $("#quizcontent").removeClass("d-none");
            $(".js-multimedia-setting").removeClass("d-none");
            $("#backgroundcolorselection").removeClass("d-none");
            break;
        default:
            $(".js-multimedia-setting").addClass("d-none");
            $("#backgroundcolorselection").removeClass("d-none");
            break;
    }

    $("#nav-setting-tab").click();
    $("#js-settings-popup").modal("show");
    e.preventDefault();
});

function rgbToHex(rgb) {
    var hex = Number(rgb).toString(16);
    if (hex.length < 2) {
        hex = "0" + hex;
    }
    return hex;
}

function fullColorHex(r, g, b) {
    var red = rgbToHex(r);
    var green = rgbToHex(g);
    var blue = rgbToHex(b);
    return red + green + blue;
}

settings = "";

// update setting on element
$(document).on("change", ".js-update-settings", function () {
    settings = $(this).closest("form").serializeArray();
     $.each(settings, function (index, value) {
        if (value.name != "background-color") {
            $(refernceBlock).find(".row").css(value.name, value.value);
        }
    });     
});
$(document).on("change", ".js-update-background", function () {
    settings = $(this).closest("form").serializeArray();
    $.each(settings, function (index, value) {
        if (value.name == "background-color") {
            $(currentBlock).css(value.name, value.value);
        }
    });
    
});

$(document).on("click", ".js-save-css-page", function () {
    var blockid = $(refernceBlock).closest("form").find(".js-course-block-id").val();
    if($('#accordioncontent').hasClass('d-none') == false){
     
        var number = $('.popupparent'+blockid).find('.item-label').length;
        for(var i=1; i<=number; i++){
            var header = $('#js-accordionheader'+blockid+i).html();
            if($('#accordionheader'+blockid+i).length){
                $('#accordionheader'+blockid+i).html(header);
                var body = $('#js-collapse'+blockid+i).html();
                $('#collapse'+blockid+i).html(body);
            }
            else{
                console.log(i,'here');
            }
            
            orderItemLabel(blockid);
        }
        beforeBlockSaving(this);
        data = {
            content: $(refernceBlock).closest("form").html(),
            id: blockid,
            configuration: settings,
        };
        saveBlockData(save_lesson_url, data, false);
        $("#js-settings-popup").modal("hide");
    }
    else if($('#videocontent').hasClass('d-none')==false){
      var newvideo = $('[name="video"]').val();
      var error = false;
      /* if(newvideo == ''){
        error = true;
        $('.error-message').html('Please enter Youtube/Vimeo URL.');
      } */
      if(newvideo !== ''){
        if (urlPattern.test(newvideo)) {
            $.ajax({
                type: "post",
                url: validembedcode_url,
                data: {"url":newvideo},
                beforeSend: function (xhr) {
                    xhr.setRequestHeader("X-CSRF-Token", csrf_token);
                },
                success: function (data) {
                   if(data == 'YouTube' || data == 'Vimeo'){
                    $('#video'+blockid).attr('data-video',newvideo);
                    $('#video'+blockid).html('');
                        if($("#video"+blockid).length){
                            var videoUrl = $("#video"+blockid).attr('data-video'); 
                            $.ajax({
                                type: "post",
                                url: videorender,
                                data: {"url":videoUrl},
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader("X-CSRF-Token", csrf_token);
                                },
                                success: function (data) {
                                    $("#video"+blockid).addClass('d-none').html('');
                                    $("#video"+blockid).removeClass('d-none').html(data);
                                },
                            });      
                        }
                        beforeBlockSaving(this);
                        data = {
                            content: $(refernceBlock).closest("form").html(),
                            id: blockid,
                            configuration: settings,
                        };
                        saveBlockData(save_lesson_url, data, false);
                        $("#js-settings-popup").modal("hide");
                   }
                   else{
                    $('.error-message').html('Added URL is invalid. Please enter Youtube/Vimeo URL.');
                   }
                },
                error: function(xhr){
                    console.log(xhr.status);
                    if(xhr.status == 401 || xhr.status == 419){
                        window.location.href = login_url;
                    }
                }
            });      
          } else {
            error = true;
            $('.error-message').html('Please enter valid Youtube/Vimeo URL.');
          }
       
      }
      else{
        beforeBlockSaving(this);
        data = {
            content: $(refernceBlock).closest("form").html(),
            id: blockid,
            configuration: settings,
        };
        saveBlockData(save_lesson_url, data, false);
        $("#js-settings-popup").modal("hide");
      }
    }
    else if($('#quizcontent').hasClass('d-none')==false){
        var correctAnswer;
        var selectedAns = [];
        var radio = false;
        var checkbox = false;
        if($("input[name='popupoptradio"+blockid+"']").length){
             correctAnswer = $("input[name='popupoptradio"+blockid+"']:checked").val();
             radio = true;
        }
        else{
             $("input[name='popupoptradio"+blockid+"[]']:checked").each(function() {
                selectedAns.push($(this).val());
              });
              checkbox = true;
        }
        
        var answerFeedback = $("#answer_feedback").val();
        var questionText = $('#question'+blockid).html();
        $('#question-container-'+blockid).html(questionText);
        var options = $('.option-cont'+blockid).length ;
        for(var j=1; j<=options; j++){
            var optiontext = $('#choice'+blockid+j).html();
           
            $('label[for="radio'+blockid+j+'"]').find('span').html(optiontext);
        }
        orderQuizItems(blockid);
        var error = false;
        if((radio && correctAnswer == '') || (radio && correctAnswer == undefined)){
            error = true;
            $('#quizmessagecont').removeClass('hide').addClass('show').find('.text-danger').html('Please select correct option.');
            clearTimeout(timeoutId1);
            timeoutId1 = setTimeout(function() {
                $('#quizmessagecont').addClass('hide').removeClass('show');
            }, 3000);
        }
        if(selectedAns.length == 0 && checkbox){
            error = true;
            $('#quizmessagecont').removeClass('hide').addClass('show').find('.text-danger').html('Please select correct options.');
            clearTimeout(timeoutId1);
            timeoutId1 = setTimeout(function() {
                $('#quizmessagecont').addClass('hide').removeClass('show');
            }, 3000);
        }
        if(error == false){
            
            beforeBlockSaving(this);
            if(checkbox == true){
                if(selectedAns.length == 0){
                    correctAnswer = 'option1';
                }
                else{
                    correctAnswer = JSON.stringify(selectedAns);
                }
                
            }
            else{
                if(correctAnswer == '' || correctAnswer == null || correctAnswer == undefined) 
                {
                    correctAnswer = 'option1';
                }  
            }
            data = {
                content: $(refernceBlock).closest("form").html(),
                id: blockid,
                configuration: settings,
                quizdata: {'correct_answer': correctAnswer ,'answer_feedback': answerFeedback} 
            };
            saveBlockData(save_lesson_url, data, false);
            $("#js-settings-popup").modal("hide");
        }
       
    }
    else if($('#audiocontent').hasClass('d-none')==false){
        var captionText = $('#audiocontent').find('.caption-text').val();
        $('.audio-caption-'+blockID).html(captionText);
        beforeBlockSaving(this);
        data = {
            content: $(refernceBlock).closest("form").html(),
            id: blockid,
            configuration: settings,
        };
        saveBlockData(save_lesson_url, data, false);
        $("#js-settings-popup").modal("hide");
    }
    else{
        beforeBlockSaving(this);
        data = {
            content: $(refernceBlock).closest("form").html(),
            id: blockid,
            configuration: settings,
        };
        saveBlockData(save_lesson_url, data, false);
        $("#js-settings-popup").modal("hide");
    }
});

$(document).on('click',"[id^='addaccordionitem-']",function(){
    var id = $(this).attr("id");
    var blockid = id.replace("addaccordionitem-", "");
    var newCnt = $('.parent'+blockid).find('.accordion-item').length ;
    newCnt++;
    var element = $(".popupparent"+blockid+":last").clone().addClass('js-newClass'+blockid+newCnt);
    $(this).parent().parent().before(element);
    $('.js-newClass'+blockid+newCnt).find('.accordion-title').html('Add Title').removeAttr('id').attr('id');
    $('.js-newClass'+blockid+newCnt).find('.js-delete-accordion').attr("value",newCnt);
    $('.js-newClass'+blockid+newCnt).find('.accordion-body').html('<div class="accordion-body"><div class="js-inline-editor">Add Tab Content</div></div>');
    $('.popupparent'+blockid).each(function(){
        if($(this).hasClass('js-newClass'+blockid+newCnt)){
         $(this).removeClass('js-newClass'+blockid+newCnt);
        }
     });
    var elementmain = $('.parent'+blockid).find('.accordion-item:last').clone().addClass('newClass'+blockid+newCnt);
    $('.parent'+blockid).append(elementmain);
    $('.newClass'+blockid+newCnt).find( '[type="button"]').removeClass().addClass('accordion-button accordionheader'+blockid).attr('data-target','#collapse'+blockid+newCnt).html('Add Title');
    $('.newClass'+blockid+newCnt).find('div.accordion-collapse').removeClass().addClass('accordion-collapse collapse'+blockid +' collapse show').html('<div class="accordion-body"><div class="js-inline-editor">Add Tab Content</div></div>');
    $('.parent'+blockid).find('.accordion-item').each(function(){
        if($(this).hasClass('newClass'+blockid+newCnt)){
         $(this).removeClass('newClass'+blockid+newCnt);
        }
     });
    EditorInit();
    orderItemLabel(blockid);
});

var timeoutId2;
$(document).on('click','.js-delete-accordion',function(){
    var itemId = $(this).attr('value');
    var blockId = $(this).data('blockid');
    if($('[id^="js-accordionheader'+blockId+'"]').length != 1){
        $('#js-accordionheader'+blockId+itemId).parent().remove();
        $('#collapse'+blockId+itemId).parent().remove();
    }
    else{
        $('#accordionmessagecont').removeClass('hide').addClass('show').find('.text-danger').html('The last element is not allowed to delete.');
        clearTimeout(timeoutId2);
            timeoutId2 = setTimeout(function() {
                $('#accordionmessagecont').addClass('hide').removeClass('show');
            }, 3000);
    }
    orderItemLabel(blockId);
});

function orderItemLabel(blockId) {
    var i = 1;
    $('.accordion_number').each(function(){
        $(this).html('').html(i);
        i++;
    });
    var n = 1;
    $(".popupparent"+blockId).find(".js-accordionheader"+blockId).each(function(){
        $(this).removeAttr('id');
        $(this).attr('id','js-accordionheader'+blockId+n);

        n++;
    });
    var k = 1;
    $(".parent"+blockId).find(".collapse"+blockId).each(function(){
        $(this).removeAttr('id').attr('id','collapse'+blockId+k);
        k++;
    });
    var m = 1;
    $(".parent"+blockId).find(".accordionheader"+blockId).each(function(){
        $(this).removeAttr('data-target').attr('data-target','#collapse'+blockId+m);
        $(this).removeAttr('id').attr('id','accordionheader'+blockId+m);
        if($(this).find('div').length){
            var text = $(this).find('div').html();
            $(this).find('div').remove();
            $(this).html(text);
        }
        
        m++;
    });
    var j = 1;
    $(".popupparent"+blockId).find(".js-collapse"+blockId).each(function(){
        $(this).removeAttr('id').attr('id','js-collapse'+blockId+j);
        j++;
    });
    var d = 1;
    $(".popupparent"+blockId).find(".js-delete-accordion").each(function(){
        $(this).removeAttr('value').attr('value',d);
        d++;
    });
}

function accordionContentTab(blockid){
    var number = 0;
    number = $('.parent'+blockid).find('.accordion-item').length;
    
    $.ajax({
        type: "post",
        url: accordion_tab_url,
        data: {"blockid":blockid,"number":number},
        beforeSend: function (xhr) {
            xhr.setRequestHeader("X-CSRF-Token", csrf_token);
        },
        success: function (data) {
            $('#accordioncontent').html(data);
            for(var i=1; i<=number; i++){
                var header = $('#accordionheader'+blockid+i).html();
                $('#js-accordionheader'+blockid+i).html(header);
                var body = $('#collapse'+blockid+i).html();
                $('#js-collapse'+blockid+i).html(body);
            }
            EditorInit();
        },
        error: function(xhr){
            console.log(xhr.status);
            if(xhr.status == 401 || xhr.status == 419){
                window.location.href = login_url;
            }
        }
    });
}

function saveBlockData(url, data, append) {
    $.ajax({
        type: "post",
        url: url,
        data: data,
        beforeSend: function (xhr) {
            xhr.setRequestHeader("X-CSRF-Token", csrf_token);
        },
        success: function (data) {
            data = $.parseJSON(data);
            if (data.status == "success") {
                if (data.content != undefined) {
                    if (append == true) {
                        $('#block-main').html(data.content);
                        if($("#add_sort_order")){
                            $("#add_sort_order").remove();
                        }
                        hideShowSort();
                        loadAllVideo();
                        EditorInit();
                    }
                }
                if(data.id == 0){
                    $('#blockmessage').removeClass('hide').addClass('show').find('span').addClass('text-danger').html(data.message);
                    clearTimeout(timeoutId);
                    timeoutId = setTimeout(function() {
                        $('#blockmessage').addClass('hide').removeClass('show').find('span').removeClass('text-danger');
                    }, 6000);
                }
                else {
                    $('#blockmessage').removeClass('hide').addClass('show').find('span').addClass('text-success').html(data.message);
                    clearTimeout(timeoutId);
                    timeoutId = setTimeout(function() {
                        $('#blockmessage').addClass('hide').removeClass('show').find('span').removeClass('text-success');
                    }, 6000);
                }
            }
            
        },
        error: function(xhr, status, error){
            console.log(xhr.status);
            if(xhr.status == 401 || xhr.status == 419){
                window.location.href = login_url;
            }
        }
    });
}
function EditorInit() {
    tinymce.remove();
    tinymce.init({
        selector: ".js-inline-editor",
        inline: true,

        branding: false,
        language: "en",
        plugins: [
            " autolink lists link image  hr anchor pagebreak",
            " code textcolor insertdatetime  fullscreen",
            "  nonbreaking save table searchreplace preview ",
            " print advlist contextmenu visualblocks charmap lineheight myplugin",
        ],
        toolbar:
            "code undo redo | bold italic underline strikethrough | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link unlink image | preview fullscreen table | hr removeformat subscript superscript charmap | forecolor backcolor spellchecker  | styleselect fontselect fontsizeselect lineheightselect mybutton",
        menubar: false,
        toolbar_items_size: "small",
        table_sizing_mode: 'fixed',
        table_toolbar: '',
        image_advtab: true,
        relative_urls: false,
        browser_spellcheck: true,
        forced_root_block: "div",
        remove_script_host: false,
        convert_urls: true,
        advlist_bullet_styles: 'disc,circle,square',
        advlist_number_styles: 'default,default-rtl,lower-alpha,lower-greek,lower-roman,upper-alpha,upper-roman',
        fontsize_formats: '8pt 10pt 12pt 13pt 13.5pt 14pt 15pt 16pt 17pt 18pt 20pt 22pt 24pt 28pt 32pt 36pt',
        font_formats: 'Andale Mono=andale mono,monospace;Arial=arial,helvetica,sans-serif;Arial Black=arial black,sans-serif;Book Antiqua=book antiqua,palatino,serif;Comic Sans MS=comic sans ms,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,palatino,serif;Helvetica=helvetica,arial,sans-serif;Impact=impact,sans-serif;Inter;Symbol=symbol;Tahoma=tahoma,arial,helvetica,sans-serif;Terminal=terminal,monaco,monospace;Muli=muli;Times New Roman=times new roman,times,serif;Trebuchet MS=trebuchet ms,geneva,sans-serif;Verdana=verdana,geneva,sans-serif;Webdings=webdings;Wingdings=wingdings,zapf dingbats',

        setup: function (editor) {
            editor.ui.registry.addIcon(
                "list-num-default-rtl",
                '<svg class="list-num-comma" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"viewBox="0 0 442.4 340.5" style="enable-background:new 0 0 442.4 340.5;" xml:space="preserve"><style type="text/css">.st0{opacity:0.2;fill-rule:evenodd;clip-rule:evenodd;enable-background:new;}.st1{enable-background:new;}</style><path id="Path_1" class="st0" d="M156.9,11.1h285.5V63H156.9V11.1z M156.9,140.8h285.5v51.9H156.9V140.8z M156.9,270.6h285.5v51.9H156.9V270.6z"/><g class="st1"><path d="M7.8,45.6c0-3.5,0.4-6.8,1.1-9.7c0.7-3,1.6-5.7,2.8-8.2S14,23,15.4,21c1.4-1.9,2.7-3.6,4-5c1.3-1.4,2.5-2.6,3.7-3.5c1.1-0.9,2-1.5,2.6-1.9l3.8,3.1c-0.5,0.3-1.1,0.8-1.9,1.6c-0.8,0.7-1.6,1.7-2.5,2.8c-0.9,1.2-1.8,2.6-2.7,4.2s-1.8,3.5-2.5,5.7c-0.8,2.1-1.4,4.5-1.9,7.2S17,40.8,16.9,44c-0.1,3.6,0.1,6.8,0.5,9.8c0.4,3,1,5.7,1.8,8.2s1.6,4.7,2.6,6.6s1.9,3.6,2.9,5c1,1.4,1.9,2.6,2.8,3.5c0.9,0.9,1.6,1.6,2.2,2l-3.9,3.1c-0.5-0.3-1.3-0.9-2.4-1.7c-1.1-0.8-2.3-1.9-3.6-3.3c-1.3-1.4-2.7-3-4.1-5c-1.4-2-2.7-4.2-3.8-6.9c-1.2-2.6-2.1-5.6-2.8-8.8C8.2,53.2,7.8,49.6,7.8,45.6z"/><path d="M37.7,69v-4.3l7.8-0.9V35.6c-0.4,0.1-1,0.3-1.7,0.4s-1.5,0.3-2.2,0.4c-0.8,0.1-1.5,0.3-2.3,0.3c-0.7,0.1-1.4,0.1-1.8,0.2l-0.9-5.4c1.3-0.3,2.6-0.7,3.9-1.2c1.3-0.5,2.6-1.1,3.8-1.7c1.2-0.6,2.4-1.3,3.4-2c1.1-0.7,2-1.4,2.9-2.1h0l5.6,1v38.2l7.2,0.9V69H37.7z"/><path d="M90.6,47.3c0,3.5-0.4,6.8-1.1,9.7c-0.7,3-1.6,5.7-2.8,8.2c-1.1,2.5-2.4,4.7-3.7,6.6c-1.4,1.9-2.7,3.6-4,5c-1.3,1.4-2.5,2.6-3.7,3.5c-1.1,0.9-2,1.5-2.6,1.9l-3.8-3.1c0.5-0.3,1.1-0.8,1.9-1.6c0.8-0.7,1.6-1.7,2.5-2.8c0.9-1.2,1.8-2.6,2.7-4.2s1.8-3.5,2.5-5.7c0.8-2.1,1.4-4.5,1.9-7.2c0.5-2.7,0.8-5.6,0.9-8.8c0.1-3.6-0.1-6.8-0.5-9.8c-0.4-3-1-5.7-1.8-8.2s-1.6-4.7-2.6-6.6c-1-1.9-1.9-3.6-2.9-5c-1-1.4-1.9-2.6-2.8-3.5c-0.9-0.9-1.6-1.6-2.2-2l3.9-3.1c0.5,0.3,1.3,0.9,2.4,1.7c1.1,0.8,2.3,1.9,3.6,3.3c1.3,1.4,2.7,3,4.1,5c1.4,2,2.7,4.2,3.8,6.9c1.2,2.6,2.1,5.6,2.8,8.8C90.2,39.6,90.6,43.3,90.6,47.3z"/></g><g class="st1"><path d="M4.9,174.6c0-3.5,0.4-6.8,1.1-9.7c0.7-3,1.6-5.7,2.8-8.2s2.4-4.7,3.7-6.6c1.4-1.9,2.7-3.6,4-5c1.3-1.4,2.5-2.6,3.7-3.5c1.1-0.9,2-1.5,2.6-1.9l3.8,3.1c-0.5,0.3-1.1,0.8-1.9,1.6c-0.8,0.7-1.6,1.7-2.5,2.8c-0.9,1.2-1.8,2.6-2.7,4.2s-1.8,3.5-2.5,5.7c-0.8,2.1-1.4,4.5-1.9,7.2s-0.8,5.6-0.9,8.8c-0.1,3.6,0.1,6.8,0.5,9.8c0.4,3,1,5.7,1.8,8.2s1.6,4.7,2.6,6.6s1.9,3.6,2.9,5c1,1.4,1.9,2.6,2.8,3.5c0.9,0.9,1.6,1.6,2.2,2l-3.9,3.1c-0.5-0.3-1.3-0.9-2.4-1.7c-1.1-0.8-2.3-1.9-3.6-3.3c-1.3-1.4-2.7-3-4.1-5c-1.4-2-2.7-4.2-3.8-6.9c-1.2-2.6-2.1-5.6-2.8-8.8C5.2,182.2,4.9,178.6,4.9,174.6z"/><path d="M33.7,193.8c3.1-1.8,6-3.7,8.7-5.8c2.7-2.1,5-4.3,6.9-6.5c1.9-2.2,3.5-4.5,4.6-6.7c1.1-2.3,1.7-4.5,1.7-6.6c0-1.1-0.2-2.1-0.5-3c-0.4-0.9-0.9-1.7-1.6-2.4s-1.5-1.2-2.5-1.6c-1-0.4-2.1-0.5-3.3-0.5c-1.3,0-2.6,0.2-3.7,0.5 c-1.1,0.3-2.1,0.7-3,1.2c-0.9,0.5-1.7,1-2.4,1.5c-0.7,0.5-1.3,1-1.8,1.4l-2.8-4.1c0.6-0.8,1.5-1.7,2.7-2.6c1.2-0.9,2.5-1.7,4-2.5 c1.5-0.8,3.2-1.4,5-1.8c1.8-0.5,3.7-0.7,5.7-0.7c2.6,0,4.8,0.3,6.7,1c1.9,0.7,3.4,1.6,4.6,2.7c1.2,1.1,2.1,2.5,2.7,3.9s0.9,3.1,0.9,4.7c0,2.3-0.6,4.7-1.8,7c-1.2,2.3-2.8,4.6-4.8,6.8c-2,2.2-4.4,4.3-7,6.3c-2.7,2-5.5,3.9-8.4,5.7l19.1-1.9l2.6-4.9l4.8,1L68.9,198H35.2L33.7,193.8z"/><path d="M98.8,176.3c0,3.5-0.4,6.8-1.1,9.7c-0.7,3-1.6,5.7-2.8,8.2c-1.1,2.5-2.4,4.7-3.7,6.6c-1.4,1.9-2.7,3.6-4,5c-1.3,1.4-2.5,2.6-3.7,3.5c-1.1,0.9-2,1.5-2.6,1.9l-3.8-3.1c0.5-0.3,1.1-0.8,1.9-1.6c0.8-0.7,1.6-1.7,2.5-2.8c0.9-1.2,1.8-2.6,2.7-4.2s1.8-3.5,2.5-5.7c0.8-2.1,1.4-4.5,1.9-7.2c0.5-2.7,0.8-5.6,0.9-8.8c0.1-3.6-0.1-6.8-0.5-9.8c-0.4-3-1-5.7-1.8-8.2s-1.6-4.7-2.6-6.6c-1-1.9-1.9-3.6-2.9-5c-1-1.4-1.9-2.6-2.8-3.5c-0.9-0.9-1.6-1.6-2.2-2l3.9-3.1c0.5,0.3,1.3,0.9,2.4,1.7c1.1,0.8,2.3,1.9,3.6,3.3c1.3,1.4,2.7,3,4.1,5c1.4,2,2.7,4.2,3.8,6.9c1.2,2.6,2.1,5.6,2.8,8.8C98.5,168.6,98.8,172.3,98.8,176.3z"/></g><g class="st1"><path d="M7.9,298.1c0-3.5,0.4-6.8,1.1-9.7c0.7-3,1.6-5.7,2.8-8.2s2.4-4.7,3.7-6.6c1.4-1.9,2.7-3.6,4-5c1.3-1.4,2.5-2.6,3.7-3.5c1.1-0.9,2-1.5,2.6-1.9l3.8,3.1c-0.5,0.3-1.1,0.8-1.9,1.6c-0.8,0.7-1.6,1.7-2.5,2.8c-0.9,1.2-1.8,2.6-2.7,4.2s-1.8,3.5-2.5,5.7c-0.8,2.1-1.4,4.5-1.9,7.2s-0.8,5.6-0.9,8.8c-0.1,3.6,0.1,6.8,0.5,9.8c0.4,3,1,5.7,1.8,8.2s1.6,4.7,2.6,6.6s1.9,3.6,2.9,5c1,1.4,1.9,2.6,2.8,3.5c0.9,0.9,1.6,1.6,2.2,2l-3.9,3.1c-0.5-0.3-1.3-0.9-2.4-1.7c-1.1-0.8-2.3-1.9-3.6-3.3c-1.3-1.4-2.7-3-4.1-5c-1.4-2-2.7-4.2-3.8-6.9c-1.2-2.6-2.1-5.6-2.8-8.8C8.2,305.7,7.9,302.1,7.9,298.1z"/><path d="M38.1,325.8c0.4,0.2,0.9,0.3,1.5,0.4c0.6,0.1,1.2,0.2,1.8,0.3s1.2,0.1,1.9,0.2c0.6,0,1.3,0.1,1.8,0.1c2.2,0,4.2-0.3,5.9-0.8c1.8-0.5,3.2-1.3,4.5-2.3c1.2-1,2.2-2.1,2.8-3.5c0.7-1.4,1-2.8,1-4.5c0-1.1-0.2-2.1-0.5-3.1c-0.3-1-0.8-1.9-1.6-2.8c-0.7-0.8-1.7-1.5-2.9-2.1c-1.2-0.5-2.6-0.9-4.4-1l-4.5,0.8l-1.8-5c1-0.1,1.9-0.3,2.9-0.7c1-0.3,1.9-0.7,2.7-1c2.8-1.1,4.8-2.6,6.2-4.4c1.3-1.8,2-3.8,2.1-6c0-1.2-0.2-2.2-0.6-3s-0.9-1.5-1.5-2.1c-0.6-0.5-1.4-0.9-2.2-1.2c-0.8-0.2-1.7-0.4-2.5-0.4c-2.2,0-4.1,0.3-5.8,0.9c-1.7,0.6-3.2,1.4-4.5,2.5l-2.5-4.4c0.5-0.5,1.3-1.2,2.4-1.8c1-0.7,2.2-1.3,3.6-1.9c1.4-0.6,2.9-1.1,4.5-1.5c1.6-0.4,3.3-0.6,5-0.6c2.1,0,4.1,0.2,5.9,0.7c1.8,0.5,3.4,1.2,4.7,2.1s2.4,2.2,3.1,3.6c0.8,1.5,1.1,3.2,1.1,5.2c0,1.8-0.3,3.5-0.9,5c-0.6,1.5-1.4,3-2.4,4.3c-1,1.3-2.3,2.4-3.8,3.4c-1.5,1-3.2,1.9-5,2.6c2.4-0.1,4.5,0.1,6.3,0.6s3.3,1.3,4.5,2.4c1.2,1,2.1,2.2,2.8,3.6c0.6,1.4,1,2.9,1,4.5c0,2.5-0.5,4.8-1.6,7c-1,2.1-2.6,4-4.7,5.6c-2.1,1.6-4.6,2.8-7.6,3.7c-3,0.9-6.5,1.3-10.5,1.3c-0.7,0-1.4,0-2.2-0.1c-0.8-0.1-1.5-0.1-2.3-0.2c-0.7-0.1-1.4-0.2-2.1-0.4c-0.7-0.1-1.2-0.3-1.7-0.5V325.8z"/><path d="M99.9,299.8c0,3.5-0.4,6.8-1.1,9.7c-0.7,3-1.6,5.7-2.8,8.2c-1.1,2.5-2.4,4.7-3.7,6.6c-1.4,1.9-2.7,3.6-4,5c-1.3,1.4-2.5,2.6-3.7,3.5c-1.1,0.9-2,1.5-2.6,1.9l-3.8-3.1c0.5-0.3,1.1-0.8,1.9-1.6c0.8-0.7,1.6-1.7,2.5-2.8c0.9-1.2,1.8-2.6,2.7-4.2s1.8-3.5,2.5-5.7c0.8-2.1,1.4-4.5,1.9-7.2c0.5-2.7,0.8-5.6,0.9-8.8c0.1-3.6-0.1-6.8-0.5-9.8c-0.4-3-1-5.7-1.8-8.2s-1.6-4.7-2.6-6.6c-1-1.9-1.9-3.6-2.9-5c-1-1.4-1.9-2.6-2.8-3.5c-0.9-0.9-1.6-1.6-2.2-2l3.9-3.1c0.5,0.3,1.3,0.9,2.4,1.7c1.1,0.8,2.3,1.9,3.6,3.3c1.3,1.4,2.7,3,4.1,5c1.4,2,2.7,4.2,3.8,6.9c1.2,2.6,2.1,5.6,2.8,8.8C99.5,292.1,99.9,295.8,99.9,299.8z"/></g></svg>'
              );
              
              
            editor.on("init", function () {
                editor.save();
            });
            editor.on("focus",function(){
                console.log($('.list-num-comma').parent().parent().attr('title'));
            });
            editor.on("change",function () {
                editor.save();
            });
        },
        images_upload_handler: function (blobInfo, success, failure) {
            var xhr, formData;
            xhr = new XMLHttpRequest();
            xhr.withCredentials = false;
            xhr.open("POST", upload_url);
            xhr.setRequestHeader("X-CSRF-Token", csrf_token);
            xhr.onload = function () {
                var json;
                if (xhr.status != 200) {
                    failure("HTTP Error: " + xhr.status);
                    return;
                }
                json = JSON.parse(xhr.responseText);

                if (!json || typeof json.location != "string") {
                    failure("Invalid JSON: " + xhr.responseText);
                    return;
                }
                success(json.location);
            };
            formData = new FormData();
            formData.append("file", blobInfo.blob(), blobInfo.filename());
            formData.append("folder", "tinymce");
            formData.append("size", "20");
            xhr.send(formData);
        },
    });
    
    tinymce.PluginManager.add('myplugin', function(editor, url) {
        editor.ui.registry.addButton('mybutton', {
          text: 'Tooltip',
          icon: 'myicon',
          onAction: function() {
            var selectedText = editor.selection.getContent({format: 'text'});
            var selectedTitle = '';
            var linkElm = editor.dom.getParent(editor.selection.getNode(), 'span');
            if(linkElm){
                // console.log(linkElm.getAttribute('data-original-title'));
                selectedTitle = linkElm.getAttribute('data-original-title') ;
                if(selectedTitle == null){
					selectedTitle = '';
				}
            }
            console.log(selectedTitle);
            editor.windowManager.open({
              title: 'Tooltip Information',
              body: {
                type: 'panel',
                items: [
                    {type: 'textarea', name: 'tooltiptitle', label: 'Tooptip Description'},
                    {type: 'input', name: 'tooltiptext', label: 'Tooptip Title'},
                ]
              },
              buttons: [
                {
                    type: 'cancel',
                    text: 'Close'
                },
                {
                  text: 'Insert',
                  type: 'submit',
                  primary: true,
                }
              ],
              initialData: {
                tooltiptext: selectedText,
                tooltiptitle: selectedTitle
              },
              onSubmit: function (api) {
                var data = api.getData();
                console.log(data);
                if( data.tooltiptext != '' && data.tooltiptitle != ''){
                     var finalTitle = data.tooltiptitle.replace(/>/g, "&gt;").replace(/</g, "&lt;").replace(/"/g, "&quot;");
                    editor.insertContent('<span class="editortooltip" data-toggle="tooltip" data-placement="top" data-original-title="'+ finalTitle +'"> ' + data.tooltiptext + '</span>');
                }
               
                api.close();
              }
            });
          }
        });
      
        editor.ui.registry.addIcon('myicon', '<svg viewBox="0 0 24 24"><path fill="#000" d="M20,0H4C2.897,0,2,0.897,2,2v20c0,1.103,0.897,2,2,2h16c1.103,0,2-0.897,2-2V2C22,0.897,21.103,0,20,0z M11,18H5v-2h6 V18z M19,16H5v-2h14V16z M19,12H5v-2h14V12z M11,8H5V6h6V8z"/></svg>');
      });
     
}
EditorInit();
$(document).on('focusin', function(e) {
    if ($(e.target).closest(".tox-tinymce, .tox-tinymce-aux, .moxman-window, .tam-assetmanager-root").length) {
      e.stopImmediatePropagation();
    }
    if ($(e.target).closest(" .tox-dialog").length) {
        e.stopImmediatePropagation();
    }
  });
  
  $(document).on('shown.bs.modal', '#js-settings-popup', function() {
    EditorInit();
  });
  $(document).on('hidden.bs.modal', '#js-settings-popup', function() {
    EditorInit();
  });
  
$(document).on("click", ".js-close-sidebar", function () {
    $(".js-courseblock-sidebar-menu").removeClass("show");
    $(".js-courseblock-sidebar-menu").addClass("hide");
    $('[id^=subblock]').each(function(){
        $(this).removeClass('show').attr('style','display:none !important;')
    });
});


$(document).on("click", ".js-master-block", function () {
    subBlockSave(this);
});

function subBlockSave(element){
    $(".js-courseblock-sidebar-menu").removeClass("show");
    $(".js-courseblock-sidebar-menu").addClass("hide");
    $('[id^=subblock]').each(function(){
        $(this).removeClass('show').attr('style','display:none !important;')
    });
    var order_id = 1;
    if($('#add_sort_order').length){
        order_id = $('#add_sort_order').html();
        data = {
            block: $(element).attr("data-block"),
            order_id: order_id
        };
    }
    else{
        data = {
            block: $(element).attr("data-block")
        };
    }
   
    saveBlockData(save_lesson_url, data, true);
}

// quiz functions
function quizContentTab(blockid){
   var number = $("#answer-buttons-"+blockid).find('.form-check').length;  
   var quizType = 1;
   if($("#answer-buttons-"+blockid).hasClass('js-quiz2')){
     quizType = 2;
   } 
    $.ajax({
        type: "post",
        url: quiz_tab_url,
        data: {"blockid":blockid,"options":number},
        beforeSend: function (xhr) {
            xhr.setRequestHeader("X-CSRF-Token", csrf_token);
        },
        success: function (data) {
            data = $.parseJSON(data);
            $('#quizcontent').html(data.html);
            var questionText = $('#question-container-'+blockid).html();
            $('#question'+blockid).html(questionText);
           
            for(var i=1; i<=number; i++){
                var optiontext = $('label[for="radio'+blockid+i+'"]').find('span').html();
                $('#choice'+blockid+i).html(optiontext);
               /*  var value = $('#radio'+blockid+i).attr('value');
                $('#js-radio'+blockid+i).attr('value',value); */
                
            }
            EditorInit();
            orderQuizItems(blockid);
            if(data.quiztype == 'quiz2'){
                var correct_answer = $.parseJSON(data.correct_answer);
                $('[id^="js-radio'+blockid+'"]').each(function(){
                    var value = $(this).attr('value');
                    if($.inArray(value, correct_answer) != -1){
                        $(this).attr('checked','checked').prop("checked", true);
                    }
                    else{
                        $(this).removeAttr('checked').prop("checked", false);
                    }
                });
            }
            else{
                var correct_answer = data.correct_answer;
                $('[id^="js-radio'+blockid+'"]').each(function(){
                    var value = $(this).attr('value');
                    
                    if(correct_answer == value){
                        $(this).attr('checked','checked').prop("checked", true);
                    }
                    else{
                        $(this).removeAttr('checked').prop("checked", false);
                    }
                });
            }
           
        },
        error: function(xhr, status, error){
            console.log(xhr.status);
            if(xhr.status == 401 || xhr.status == 419){
                window.location.href = login_url;
            }
        }
    });
}

$(document).on("click","[id^='quizoption']",function(){
    var id = $(this).attr("id");
    var blockid = id.replace("quizoption-", "");
    var newCnt = $('.option-cont'+blockid).length ;
    newCnt++;
    var radioSelection = '';
    if(!$("#answer-buttons-"+blockid).hasClass('js-quiz2')){
        radioSelection = $('input[name="popupoptradio'+blockid+'"]:checked').val();
    }
    var element = $(".option-cont"+blockid+":last").clone().addClass('js-newansoption'+blockid+newCnt);
    $('.answers'+blockid).append(element);
    $('.js-newansoption'+blockid+newCnt).find('.choicetext').html('Add Choice');
    $('.js-newansoption'+blockid+newCnt).find('.js-delete-quiz').attr("value",newCnt);
    $('.js-newansoption'+blockid+newCnt).find('.form-check-input').remove();
    if($("#answer-buttons-"+blockid).hasClass('js-quiz2')){
        $('.js-newansoption'+blockid+newCnt).find('.js-radio-cont').html('<input type="checkbox" class="form-check-input" id="js-radio'+blockid+newCnt+'" name="popupoptradio'+blockid+'[]" value="option'+newCnt+'" >');
    }
    else{
        $('.js-newansoption'+blockid+newCnt).find('.js-radio-cont').html('<input type="radio" class="form-check-input" id="js-radio'+blockid+newCnt+'" name="popupoptradio'+blockid+'" value="option'+newCnt+'" >');
        if($('input[name="popupoptradio'+blockid+'"]:checked').length == 0){
            $('input[name="popupoptradio'+blockid+'"][value=' + radioSelection + ']').prop('checked', true);
        }
    }
   
    $('.answers'+blockid).find(".option-cont"+blockid).each(function(){
       if($(this).hasClass('js-newansoption'+blockid+newCnt)){
            $(this).removeClass('js-newansoption'+blockid+newCnt);
       }
    });
    var mainelement = $("#answer-buttons-"+blockid).find('.form-check:last').clone().addClass('newansoption'+blockid+newCnt);
    $("#answer-buttons-"+blockid).append(mainelement);
    $('.newansoption'+blockid+newCnt).find('.form-check-input').removeAttr('checked').attr('value','option'+newCnt).prop('checked', false);
    $('.newansoption'+blockid+newCnt).find('.form-check-label').html('').html('<span >Add Choice</span>');
    $("#answer-buttons-"+blockid).find(".form-check").each(function(){
        if($(this).hasClass('newansoption'+blockid+newCnt)){
         $(this).removeClass('newansoption'+blockid+newCnt);
        }
        if($(this).hasClass('bg-active')){
            $(this).removeClass('bg-active');
        }
     });
     EditorInit();
    orderQuizItems(blockid);
});

function orderQuizItems(blockId){
    var i = 1;
    $('.js-delete-quiz').each(function(){
        $(this).removeAttr('value').attr('value',i);
        i++;
    });
    var j = 1;
    $(".answers"+blockId).find(".choicetext").each(function(){
        $(this).removeAttr('id');
        $(this).attr('id','choice'+blockId+j);
        j++;
    });
    var k = 1;
    $(".answers"+blockId).find(".option-cont"+blockId).each(function(){
        $(this).removeAttr('id');
        $(this).attr('id','js-option-'+blockId+k);
        k++;
    });
    var l = 1;
    $(".answers"+blockId).find(".form-check-input").each(function(){
        $(this).removeAttr('id');
        $(this).attr('id','js-radio'+blockId+l);
        $(this).removeAttr('value');
        $(this).attr('value','option'+l);
        l++;
    });
    var m = 1;
    $("#answer-buttons-"+blockId).find('.form-check-input').each(function(){
        $(this).removeAttr('id');
        $(this).attr('id','radio'+blockId+m);
        $(this).removeAttr('value');
        $(this).attr('value','option'+m);
        m++;
    });
    var n = 1;
    $("#answer-buttons-"+blockId).find('.form-check-label').each(function(){
        $(this).removeAttr('for');
        $(this).attr('for','radio'+blockId+n);
        n++;
    });
}
var timeoutId1;
$(document).on('click','.js-delete-quiz',function(){
    var itemId = $(this).attr('value');
    var blockId = $(this).data('blockid');
    
    if($('.answers'+blockId).find('.choicetext').length > 2){
        $('#js-option-'+blockId+itemId).remove();
        $('#radio'+blockId+itemId).parent().remove();
    }
    else{
        $('#quizmessagecont').removeClass('hide').addClass('show').find('.text-danger').html('The last two element is not allowed to delete.');
        clearTimeout(timeoutId1);
            timeoutId1 = setTimeout(function() {
                $('#quizmessagecont').addClass('hide').removeClass('show');
            }, 3000);
    }
    orderQuizItems(blockId);
});
$(document).on("change","input[name^='popupoptradio']",function(){
    var id = $(this).attr('id');
    console.log('here');
    var replaceid = id.replace('radio','js-radio');
    if ($(this).is(':checked')) {
        $(replaceid).attr('checked','checked');
    } else {
        $(replaceid).removeAttr('checked');
    }
    
});

//quiz functions end

//delete media functions
$(document).on("change", ".media-video-url-update",function(){
    $('#media_error').addClass('d-none').html('');
    var newvideo = $('[name="media_video"]').val();
    var lessonid = $(this).attr("lesson");
    var error = false;
    if(newvideo == ''){
      error = true;
      $('#media_error').removeClass('d-none').html('Please enter Youtube/Vimeo URL.');
    }
    if(newvideo !== ''){
        if (urlPattern.test(newvideo)) {
            $.ajax({
                type: "post",
                url: validembedcode_url,
                data: {"url":newvideo},
                beforeSend: function (xhr) {
                    xhr.setRequestHeader("X-CSRF-Token", csrf_token);
                },
                success: function (data) {
                   if(data == 'YouTube' || data == 'Vimeo'){
                    $('#js-media-popup').modal('hide');
                    $('[data-model="video"]').removeClass('fill-active').addClass('fill-active');
                    $.ajax({
                        type: "post",
                        url: saveMediavideo_url,
                        data: {"url":newvideo,"lessonid":lessonid},
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader("X-CSRF-Token", csrf_token);
                        },
                        success: function (data) {
                            $.ajax({
                                type: "get",
                                url: media_popup_refresh,
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader("X-CSRF-Token", csrf_token);
                                },
                                success: function (data) {
                                    $('#mediablockpopup').html(data);
                                },
                            });
                        },
                    });     
                   }
                   else{
                    $('#media_error').removeClass('d-none').html('Added URL is invalid. Please enter Youtube/Vimeo URL.');
                   }
                },
                error: function(xhr){
                    console.log(xhr.status);
                    if(xhr.status == 401 || xhr.status == 419){
                        window.location.href = login_url;
                    }
                }
            }); 
        }
        else{
            error = true;
            $('#media_error').removeClass('d-none').html('Please enter valid Youtube/Vimeo URL.');
        }    
    }

});
$(document).on("click","[id^='delete-media-']",function(){
    var mediaid = $(this).attr('id').replace('delete-media-','');
    var type = $(this).attr('data-type');
    $.ajax({
        type: "post",
        url: media_delete_url,
        data: {"mediaid":mediaid,"type":type},
        beforeSend: function (xhr) {
            xhr.setRequestHeader("X-CSRF-Token", csrf_token);
        },
        success: function (data) {
            console.log(data);
            $('#media_error').addClass('d-none').html('');
            $('#media_success').addClass('d-none').html('')
            if (data.flag == "success") {
                $('#media_success').removeClass('d-none').html(data.message);
                var folder = data.folder;
                
                $('#js-media-popup').modal('hide');
                $.ajax({
                    type: "get",
                    url: media_popup_refresh,
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader("X-CSRF-Token", csrf_token);
                    },
                    success: function (data) {
                        $('#mediablockpopup').html(data);
                        $('.media-model').addClass('d-none');
                        $('#'+folder).removeClass('d-none');
                        if(folder == 'audio'){
                            $('#lesson-audio').addClass('d-none');
                        }
                        if($('#documents-media-list').length == 0){
                            $('[data-model="'+folder+'"]').find('a').removeClass('active');
                            $('[data-model="'+folder+'"]').removeClass('fill-active');
                        }
                        else{
                            $('[data-model="'+folder+'"]').removeClass('fill-active');
                        }
                        $('#js-media-popup').modal('show');
                        
                    },
                });
                
                
            }
            else{
                $('#media_error').removeClass('d-none').html(data.message);
            }
            
        },
        error: function(xhr, status, error){
            console.log(xhr.status);
            if(xhr.status == 401 || xhr.status == 419){
                window.location.href = login_url;
            }
        }
    });
});

//delete media functions